<?php

namespace backend\controllers;
use Yii;
use common\models\TehnicReview;
use common\models\Tehnical;
use common\models\RestApiAuth;
use common\models\Role;
use common\models\User;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\web\Response;
use kartik\mpdf\Pdf;
use DateTime;
use DateTimeZone;
use yii\data\Pagination;
use yii\helpers\ArrayHelper;

class RestApiController extends Controller
{
    public function actionIndex()
    {	
    	\Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

    	$objects = array();
    	$data = $_SERVER;

    	if( $data && $data["HTTP_ACCESS_TOKEN"] && $data["HTTP_CLIENT_SECRET"] ) {

	    	$token = $data["HTTP_ACCESS_TOKEN"];
	    	$secret = $data["HTTP_CLIENT_SECRET"];
			$restApiAuth = RestApiAuth::find()->where(['token' => $token, 'client_secret' => $secret])->one();
            $users = User::find()->select('id')->where(['Betreiber' => $restApiAuth->name])->all();
            $user_ids = [];

            foreach ($users as $key => $user) {
                array_push($user_ids, $user->id);
            }

	    	if( count($user_ids) > 0 ) {

	    		$lifts = Tehnical::find()->where(['user_id' => $user_ids ])
    			->orderBy('id DESC')->all();

				foreach ($lifts as $key => $lift) {
		    		$prufungen = $lift->getTehnicReviews()->where(['Art' => ['Wiederkehrende Überprüfung', 'Wiederkehrende Überprüfung und Abnahmeprüfung nach Instandsetzungen'], 'coworker_active' => 1])->orderBy('id DESC')->one();

					if( isset($prufungen->id) && isset($prufungen->id)) {

			    		$mangels = $prufungen->getMangels()->all();

                        $mangelObjects = [
                            '0' => [],
                            '1' => []
                        ];

                        if(count($mangels) > 0) {
                            $_mangels = [];
                            $al = [];

                            foreach ($mangels as $key => $mangel) {
                                $mangelObject = array(
                                    'Mangel' => $mangel->mangel,
                                    'Frist' => $mangel->frist,
                                    'Foto' => ( $mangel->photo && $mangel->photo != "" ) ? "https://freieingenieure.s3.eu-central-1.amazonaws.com/live/image/".$mangel->photo: null,
                                );

                                if($mangel->type == 1) {
                                    array_push($mangels, $mangelObject);
                                    if($mangel->al != '' && $mangel->al != null) {
                                        array_push($al, $mangel->al);
                                    }
                                }
                                else {
                                    array_push($mangelObjects['0'], $mangelObject);
                                }
                            }

                            if(count($al) > 0) {
                                $mangelObjects['1']['AI'] = $al;
                            }

                            if(count($_mangels) > 0) {
                                $mangelObjects['1']['Mängel'] = $_mangels;
                            }
                        }

						$zustand_images = $prufungen->display_allgemeiner_zustand_images();
						$zustand_images_objects = array();


						if( count($zustand_images) > 0 ) {
							foreach ($zustand_images as $key => $image) {
								$zustand_images_object = array(
									'Foto' => $image->url ? "https://freieingenieure.s3.eu-central-1.amazonaws.com/live/image/".$image->url : null,
								);
								array_push($zustand_images_objects, $zustand_images_object);
							}
						}


						$wartungsbuch = $prufungen->display_wartungsbuch_images();
						$wartungsbuch_objects = array();

						if( count($wartungsbuch) > 0 ) {
							foreach ($wartungsbuch as $key => $image) {
								$wartungsbuch_object = array(
									'Foto' => $image->url ? "https://freieingenieure.s3.eu-central-1.amazonaws.com/live/image/".$image->url : null,
								);
								array_push($wartungsbuch_objects, $wartungsbuch_object);
							}							
						}


                        $object = array(                
                            'AnlagenNrFI' => "AT".$lift->id,
                            'AnlagenNrKunde' => '',
                            'FabriksNr' => $lift->FabriksNr,
                            'Baujahr' => $lift->Baujahr,
                            'Type' => $lift->Type,
                            'Hersteller' => $lift->Hersteller,
                            'Antriebsart' => $lift->Antriebsart,
                            'Personen' => $lift->Personen,
                            'Nennlast' => $lift->Nennlast,
                            'Haltestellen' => $lift->Haltestellen,
                            'Ladestellen' => $lift->Ladestellen,
                            'Foerderhoehe' => $lift->Hubhohe ? $lift->Hubhohe. " m" : null,
                            'Nenngeschwindigkeit' => $lift->Nenngeschwindigkeit,
                            'Baujahr' => $lift->Baujahr,
                            'AnlagenNrKunde' => $lift->AnlagenNrKunde,
                            'PLZ' => $lift->AdressePLZ,
                            'Ort' => $lift->AdresseOrt,
                            'Strasse' => $lift->AdresseStreat,
                            'Zusatz' => $lift->Zusatz,
                            'Pruefungsdatum' => $prufungen->Prufungsdatum,
                            'Pruefer' => $prufungen->author_full_name,
                            'Maengel vorth' =>  $prufungen->Mangel == 1 ? "JA" : "Nein" ,
                            'Abnahmeprüfung nach Insatzsetzung' => $mangelObjects['1'],
                            'Unabhängige Mängel' => $mangelObjects['0'],
                            'AllgemeinerZustand' => $prufungen->AllgemeinerZustand,
                            'Anmerkungen' => $prufungen->Anmerkungen,
                            'FotosAZ' => $zustand_images_objects,
                            'Wartungsbuch' => $wartungsbuch_objects,
                            'pdf' => "https://freieingenieure.s3.eu-central-1.amazonaws.com/live/pdf/". $prufungen->url
                        );

			    		array_push($objects, $object);	
					}
		    	}

		    	return $objects;
	    	}else {
	    		return 'Wrong token OR client_secret';
	    	}

    	}else {
    		return 'Wrong token OR client_secret';
    	}
    
    }
}
