<?php

namespace backend\controllers;

use Yii;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;
use kartik\select2\Select2;
use common\models\User;
use common\models\TehnicReview;
use common\models\Tehnical;
use common\models\RestApiAuth;
use common\models\Role;
use kartik\mpdf\Pdf;
use DateTime;
use DateTimeZone;
use yii\helpers\ArrayHelper;
/**
 * RestApiAuthController implements the CRUD actions for RestApiAuth model.
 */
class RestApiAuthController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        if ($this->currentUser() && $this->currentUser()->role_id != "1")
        {
            $this->redirect(['site/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all RestApiAuth models.
     * @return mixed
     */
    public function actionIndex()
    {

        $query = RestApiAuth::find();
        $count = $query->count();

        $pagination = new Pagination([
            'defaultPageSize' => 20,
            'totalCount' => $count,
        ]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => ['pageSize' => 20],
        ]);

        $desktop = $this->isDesktop();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'desktop' => $desktop,
            'pagination' => $pagination,
        ]);

    }

    /**
     * Displays a single RestApiAuth model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $data = $this->findModel($id);

        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $objects = array();

        if( $data && $data["token"] && $data["client_secret"] ) {

            $token = $data["token"];
            $secret = $data["client_secret"];
            $restApiAuth = RestApiAuth::find()->where(['token' => $token, 'client_secret' => $secret])->one();
            $users = User::find()->select('id')->where(['Betreiber' => $restApiAuth->name])->all();
            $user_ids = [];

            foreach ($users as $key => $user) {
                array_push($user_ids, $user->id);
            }

            if( count($user_ids) > 0 ) {

                $lifts = Tehnical::find()->where(['user_id' => $user_ids])
                ->orderBy('id DESC')->all();

                foreach ($lifts as $key => $lift) {
                    $prufungen = $lift->getTehnicReviews()->where([
                            'Art' => ['Wiederkehrende Überprüfung', 'Wiederkehrende Überprüfung und Abnahmeprüfung nach Instandsetzungen'], 
                            'coworker_active' => 1
                        ])->orderBy('id DESC')->one();
                    
                    if( isset($prufungen->id) && isset($prufungen->id)) {

                        $mangels = $prufungen->getMangels()->all();

                        $mangelObjects = [
                            '0' => [],
                            '1' => []
                        ];

                        if(count($mangels) > 0) {
                            $_mangels = [];
                            $al = [];

                            foreach ($mangels as $key => $mangel) {
                                $mangelObject = array(
                                    'Mangel' => $mangel->mangel,
                                    'Frist' => $mangel->frist,
                                    'Foto' => ( $mangel->photo && $mangel->photo != "" ) ? "https://freieingenieure.s3.eu-central-1.amazonaws.com/live/image/".$mangel->photo: null,
                                );

                                if($mangel->type == 1) {
                                    array_push($mangels, $mangelObject);
                                    if($mangel->al != '' && $mangel->al != null) {
                                        array_push($al, $mangel->al);
                                    }
                                }
                                else {
                                    array_push($mangelObjects['0'], $mangelObject);
                                }
                            }

                            if(count($al) > 0) {
                                $mangelObjects['1']['AI'] = $al;
                            }

                            if(count($_mangels) > 0) {
                                $mangelObjects['1']['Mängel'] = $_mangels;
                            }
                        }

                        $zustand_images = $prufungen->display_allgemeiner_zustand_images();
                        $zustand_images_objects = array();


                        if( count($zustand_images) > 0 ) {
                            foreach ($zustand_images as $key => $image) {
                                $zustand_images_object = array(
                                    'Foto' => $image->url ? "https://freieingenieure.s3.eu-central-1.amazonaws.com/live/image/".$image->url: null,
                                );
                                array_push($zustand_images_objects, $zustand_images_object);
                            }
                        }


                        $wartungsbuch = $prufungen->display_wartungsbuch_images();
                        $wartungsbuch_objects = array();

                        if( count($wartungsbuch) > 0 ) {
                            foreach ($wartungsbuch as $key => $image) {
                                $wartungsbuch_object = array(
                                    'Foto' => $image->url ? "https://freieingenieure.s3.eu-central-1.amazonaws.com/live/image/".$image->url : null,
                                );
                                array_push($wartungsbuch_objects, $wartungsbuch_object);
                            }                           
                        }


                        $object = array(                
                            'AnlagenNrFI' => "AT".$lift->id,
                            'AnlagenNrKunde' => '',
                            'FabriksNr' => $lift->FabriksNr,
                            'Baujahr' => $lift->Baujahr,
                            'Type' => $lift->Type,
                            'Hersteller' => $lift->Hersteller,
                            'Antriebsart' => $lift->Antriebsart,
                            'Personen' => $lift->Personen,
                            'Nennlast' => $lift->Nennlast,
                            'Haltestellen' => $lift->Haltestellen,
                            'Ladestellen' => $lift->Ladestellen,
                            'Foerderhoehe' => $lift->Hubhohe ? $lift->Hubhohe. " m" : null,
                            'Nenngeschwindigkeit' => $lift->Nenngeschwindigkeit,
                            'Baujahr' => $lift->Baujahr,
                            'AnlagenNrKunde' => $lift->AnlagenNrKunde,
                            'PLZ' => $lift->AdressePLZ,
                            'Ort' => $lift->AdresseOrt,
                            'Strasse' => $lift->AdresseStreat,
                            'Zusatz' => $lift->Zusatz,
                            'Pruefungsdatum' => $prufungen->Prufungsdatum,
                            'Pruefer' => $prufungen->author_full_name,
                            'Maengel vorth' =>  $prufungen->Mangel == 1 ? "JA" : "Nein" ,
                            'Abnahmeprüfung nach Insatzsetzung' => $mangelObjects['1'],
                            'Unabhängige Mängel' => $mangelObjects['0'],
                            'AllgemeinerZustand' => $prufungen->AllgemeinerZustand,
                            'Anmerkungen' => $prufungen->Anmerkungen,
                            'FotosAZ' => $zustand_images_objects,
                            'Wartungsbuch' => $wartungsbuch_objects,
                            'pdf' => "https://freieingenieure.s3.eu-central-1.amazonaws.com/live/pdf/". $prufungen->url
                        );

                        array_push($objects, $object);  
                    }
                }

                return $objects;
            }else {
                return 'Wrong token OR client_secret';
            }

        }else {
            return 'Wrong token OR client_secret';
        }
    }

    /**
     * Creates a new RestApiAuth model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new RestApiAuth();

       /* $model->token = "token-".$model->name->bin2hex(openssl_random_pseudo_bytes(5));
        $model->token = "token-".$model->name->bin2hex(openssl_random_pseudo_bytes(5));*/

        if ($model->load(Yii::$app->request->post())) {

            $user = User::findOne($model->company_id);
            $model->token = sha1("token-".$user->Betreiber) ."-". $user->id ."-". bin2hex(openssl_random_pseudo_bytes(5));
            $model->client_secret = sha1("token-".$user->Betreiber)."-". $user->id ."-". bin2hex(openssl_random_pseudo_bytes(5));
            $model->name = $user->Betreiber;
            $model->save();

            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing RestApiAuth model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing RestApiAuth model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the RestApiAuth model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return RestApiAuth the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = RestApiAuth::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}