<?php

namespace backend\controllers;

use Yii;
use common\models\User;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\web\Response;
use yii\db\Expression;
/**
 * ProfileController implements the CRUD actions for User model.
 */
class ProfileController extends BaseController
{

    public function behaviors()
    {
        if ($this->currentUser() && $this->currentUser()->role_id != "1")
        {
            $this->redirect(['site/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all User models.
     * @return mixed
     */
    public function actionIndex()
    {
        $dataProvider = $this->currentUser();

        return $this->render('index', [
            'model' => $dataProvider,
        ]);
    }

    /**
     * Updates an existing User model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {

        $user_id = Yii::$app->user->getId();
        $url_id = $_GET['id'];

        if ( $url_id != $user_id ) {

            return $this->redirect(['index']);
        }

        $model = $this->findModel($id);
        $model->setScenario('requiredName');
        $model->active = 1;
        $s3_env = S3_ENV;
        $old_picture = $model->OldAttributes['image'];
        $old_stamp = $model->OldAttributes['stamp'];
         

        if($model->load(Yii::$app->request->post()) ) {


            $model->email = $model->username;

            $image = UploadedFile::getInstance($model, 'image');
            $random_string = bin2hex(openssl_random_pseudo_bytes(5));
            $imageformat = $image ? $image->baseName. bin2hex(openssl_random_pseudo_bytes(5)).'.'.$image->extension : $old_picture;
            $model->image = $imageformat;


            $stamp = UploadedFile::getInstance($model, 'stamp');
            $random_string = bin2hex(openssl_random_pseudo_bytes(5));
            $stampformat = $stamp ? $stamp->baseName. bin2hex(openssl_random_pseudo_bytes(5)).'.'.$stamp->extension : $old_stamp;
            $model->stamp = $stamp;



            if($model->save()) {
                Yii::$app->session->setFlash('success', 'You have successfully updated profile!');                
            }


            if ( $image ) {
                $image->saveAs('uploads/'.$model->image);
                Yii::$app->get('s3bucket')->upload($s3_env. 'profile/'.$model->image, 'uploads/'.$model->image);
                gc_collect_cycles();
                unlink('uploads/'.$model->image); 
                $this->deleteFromS3($old_picture, $s3_env);
            }

            if ( $stamp ) {
                $stamp->saveAs('uploads/'.$model->stamp);
                Yii::$app->get('s3bucket')->upload($s3_env. 'profile/'.$model->stamp, 'uploads/'.$model->stamp);
                gc_collect_cycles();
                unlink('uploads/'.$model->stamp); 
                $this->deleteFromS3($old_stamp, $s3_env);
            }


            return $this->redirect(['index']);

        } else {

            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }


    public function actionPassword($id)
    {
        $model = $this->findModel($id);
        $model->setScenario('changePwd');
        $model->active = 1;

        if ($model->load(Yii::$app->request->post()) && Yii::$app->security->validatePassword($model->old_password, $model->password_hash) ) {
            $model->setPassword($model->new_password);
            $model->client_password = $model->new_password;
            $model->save();
            return $this->redirect(['index']);

        } else {
            $model->old_password ? $model->addError('old_password', 'Incorrect old password.') : "";
            return $this->render('password', [
                'model' => $model,
            ]);
        }
    }


    /**
     * Deletes an existing User model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the User model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return User the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = User::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    protected function deleteFromS3($image, $env)
    {
        $env = $env;
        if ($image) {
            Yii::$app->get('s3bucket')->delete($env. 'profile/'.$image);
        }
    }
}
