<?php

namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\web\Response;
use common\models\Tehnical;
use common\models\Images;
use common\models\search\TehinicalSearch;
use common\models\Aufzugswarter;
use common\models\AufzugswarterTehnicJoin;
use common\models\User;
use common\models\Wartungsfirma;
use common\models\Type;
use common\models\Antriebsart;
use common\models\Betriebskontrollen;
use common\models\Wartungsart;
use common\models\Anlagentyp;
use common\models\AnlagenStatus;
use common\models\Evaluierung;
use common\models\TehnicReview;
use common\models\GeratMangel;
use kartik\mpdf\Pdf;
use common\models\Magel;

class PdfController extends PdfBaseController
{

    public function actionPdfView($id)
    {
        
        $lift = $this->findModel($id);
        $prufungen = $lift->getTehnicReviews()->orderBy('id DESC')->one();
        $betraiber_user = User::find()->where(['id' => $lift->user_id])->one();
        $betreiber_pdf = $betraiber_user->BetreiberPdf;

        if( $prufungen ) {

            $mangelsInputArray = Magel::find()->where(['tehnic_review_id_integer' => $prufungen->id ])->all();
            
            /*$prufungen->mangelsInputArray = $mangelsInputArray;
            $prufungen->numberOfFrist = 0;
            $prufungen->numberOFMangel = 0;

            foreach ($mangelsInputArray as $key => $value) {
                if($value->mangel != "") {
                    $prufungen->numberOFMangel = $prufungen->numberOFMangel + 1;
                }
            }

            $arrayOfFristNumbers = array();
            $arrayOfFrists = array();
            $resultOfFrists = array();

            foreach ($mangelsInputArray as $key => $mangel) {
                $arrayOfFristNumbers[$mangel->frist] = array();
            }

            foreach ($mangelsInputArray as $key => $mangel) {
                if( $mangel->frist != "" && $mangel->frist != null ) {
                    if (array_key_exists($mangel->frist, $arrayOfFristNumbers)) {
                        array_push($arrayOfFrists, $mangel->frist);
                    }else {
                        array_push($arrayOfFrists, $mangel->frist);
                    }

                    array_push($arrayOfFristNumbers[$mangel->frist], $key + 1);
                }
            }

            $arrayOfFrists = array_unique($arrayOfFrists);

            foreach ($arrayOfFrists as $key => $frist) {
                $frist = implode(",",$arrayOfFristNumbers[$frist]). ")" .$frist ."  ";
                array_push($resultOfFrists, $frist);
            }

            $prufungen->numberOfFrist = count($resultOfFrists);
            $prufungen->arrayOfFrists = $resultOfFrists;*/
           
            $prufungen->mangelsInputArray = $this->strucutreMangales($mangelsInputArray);
            
        }

        $css = $this->returnCSS($prufungen, $lift);
        $content = $this->returnPreviewContent($prufungen, $lift, $betreiber_pdf);

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_UTF8,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => $css,
            'options' => [
                'defaultheaderline' => 0,
                'title' => 'anlagendoku',
                'subject' => 'www.freieingenieure.com'
            ],
            'methods' => [
                'SetHTMLFooter'=>['<p style= "font-size: 9px; color: #808080; padding-top: 8px; text-align: center; font-weight: 100; margin-left: 45px; font-style: normal;">FI - Technisches Büro für Aufzugstechnik e.U. • www.freieingenieure.com • aufzug@freieingenieure.com • 0664 / 329 15 87</p><p style= "font-size: 9px; color: #808080; text-align: center; font-weight: 100; margin-left: 45px; font-style: normal;">Karmarschgasse 48/1, 1100 Wien • HG Wien • FN 453977 p • ATU 71260538</p>'],
            ]
        ]);
        
        return $pdf->render();
   	}
       /*
    function strucutreMangales($mangelsInputArray) {
        $retData = [
            '1' => [
                'arrayOfAl' => [],
                'mangels' => [],
                'numberOFMangel' => 0,
                'numberOfFrist' => 0,
                'arrayOfFristNumbers' => [],
                'arrayOfFrists' => []
            ],
            '0' => [
                'arrayOfAl' => [],
                'mangels' => [],
                'numberOFMangel' => 0,
                'numberOfFrist' => 0,
                'arrayOfFristNumbers' => [],
                'arrayOfFrists' => []
            ] 
        ];

        foreach ($mangelsInputArray as $key => $value) {
            if($value->mangel != "") {
                $retData[$value->type]['numberOFMangel'] += 1;
                array_push($retData[$value->type]['mangels'], $value->mangel);
            }
        }

        foreach ($mangelsInputArray as $key => $mangel) {
            $retData[$mangel->type]['arrayOfFristNumbers'][$mangel->frist] = array();
        }

        foreach ($mangelsInputArray as $key => $mangel) {
            if( $mangel->frist != "" && $mangel->frist != null ) {
                if (array_key_exists($mangel->frist, $retData[$mangel->type]['arrayOfFristNumbers'])) {
                    array_push($retData[$mangel->type]['arrayOfFrists'], $mangel->frist);
                }else {
                    array_push($retData[$mangel->type]['arrayOfFrists'], $mangel->frist);
                }

                array_push($retData[$mangel->type]['arrayOfFristNumbers'][$mangel->frist], $key + 1);
            }

            if($mangel->al != "" && $mangel->al != null) {
                array_push($retData[$mangel->type]['arrayOfAl'], $mangel->al);
            }
        }

        $retData['0']['arrayOfFrists'] = array_unique($retData['0']['arrayOfFrists']);
        $retData['1']['arrayOfFrists'] = array_unique($retData['1']['arrayOfFrists']);

        $resultOfFrists = [];
        foreach ($retData['0']['arrayOfFrists'] as $key => $frist) {
            $frist = implode(",",$retData['0']['arrayOfFristNumbers'][$frist]). ")" .$frist ."  ";
            array_push($resultOfFrists, $frist);
        }
        $retData['0']['numberOfFrist'] = count($resultOfFrists);
        $retData['0']['arrayOfFrists'] = array_unique($resultOfFrists);

        $resultOfFrists = [];
        foreach ($retData['1']['arrayOfFrists'] as $key => $frist) {
            $frist = implode(",",$retData['1']['arrayOfFristNumbers'][$frist]). ")" .$frist ."  ";
            array_push($resultOfFrists, $frist);
        }
        $retData['1']['numberOfFrist'] = count($resultOfFrists);
        $retData['1']['arrayOfFrists'] = array_unique($resultOfFrists);
        return $retData;
    }
    */
    public function actionBeschreibungPdf($id)
    {

        $lift = $this->findModel($id);
        $prufungen = $lift->getTehnicReviews()->orderBy('id DESC')->one();
        $content = $this->renderPartial('_beschreibung', ['lift' => $lift, 'prufungen' => $prufungen]);

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_UTF8,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'content' => $content,
        'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
        'cssInline' => '',
            'options' => [
                'title' => 'anlagendoku',
                'subject' => 'www.freieingenieure.com'
            ],
            'methods' => [
                'SetHTMLFooter'=>['<p style= "font-size: 9px; color: #808080; padding-top: 8px; text-align: center; font-weight: 100; margin-left: 45px; font-style: normal;">FI - Technisches Büro für Aufzugstechnik e.U. • www.freieingenieure.com • aufzug@freieingenieure.com • 0664 / 329 15 87</p><p style= "font-size: 9px; color: #808080; text-align: center; font-weight: 100; margin-left: 45px; font-style: normal;">Karmarschgasse 48/1, 1100 Wien • HG Wien • FN 453977 p • ATU 71260538</p>'],
            ]
        ]);
        
        return $pdf->render();
    }


    public function actionStoreOnS3PDF() {

  
        $model = $this->findModel($id);
        $content = $this->renderPartial('_reportView', ['model' => $model]);
        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_UTF8, // leaner size using standard fonts
            'content' => $content,
        'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
        'cssInline' => '.pdf-header{}',
            'options' => [
                'title' => 'anlagendoku',
                'subject' => 'www.freieingenieure.com '
            ],
            'methods' => [
            ]
        ]);
        return $pdf->render();
    }

    protected function findModel($id)
    {
        if (($model = Tehnical::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}


