<?php

namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\web\Response;
use common\models\TehnicalDocument;
use common\models\Tehnical;
use common\models\Images;
use common\models\search\TehinicalSearch;
use common\models\Aufzugswarter;
use common\models\AufzugswarterTehnicJoin;
use common\models\User;
use common\models\Art;
use common\models\Wartungsfirma;
use common\models\Type;
use common\models\Antriebsart;
use common\models\Betriebskontrollen;
use common\models\Wartungsart;
use common\models\Anlagentyp;
use common\models\AnlagenStatus;
use common\models\Evaluierung;
use common\models\TehnicReview;
use common\models\GeratMangel;
use kartik\mpdf\Pdf;
use DateTime;
use DateTimeZone;
use yii\helpers\ArrayHelper;
use yii\imagine\Image;
use Imagine\Gd;
use Imagine\Image\Box;
use Imagine\Image\BoxInterface;
use common\models\Magel;
use common\models\Frist;
use common\models\MangelProperties;
use common\models\AlProperties;
use common\models\PrufungenImage;
/**
 * AdminController implements the CRUD actions for User model.
 */
class PdfBaseController extends BaseController
{


	protected function returnPreviewContent($prufungen, $lift, $betreiber_pdf = true)
	{

		if ( $prufungen ) {

            if ( $lift->Type == "Spielplatzgeräte" ) {
                
                $gerat_mangels = GeratMangel::find()->all();
                return $content = $this->renderPartial('/pdf-base/_spielplatzgerate_preview', ['lift' => $lift, 'prufungen' => $prufungen, 'gerat_mangels' => $gerat_mangels ]);
            }else if ( $lift->Type == "KFZ Parkeranlage" ) {

                return $content = $this->renderPartial('/pdf-base/_parkeranlagen_preview', ['lift' => $lift, 'prufungen' => $prufungen ]);
            }else if ( $lift->Type == "Arbeitsmittel" ) {

                return $content = $this->renderPartial('/pdf-base/_arbeitsmittel_preview', ['lift' => $lift, 'prufungen' => $prufungen ]);
            }else {

                return $content = $this->renderPartial('/pdf-base/_reportView_preview', ['lift' => $lift, 'prufungen' => $prufungen, 'betreiber_pdf' => $betreiber_pdf ]);
            }
        }else {

            return $content = $this->renderPartial('/pdf-base/_emty');
        }		
	}

    protected function returnContent($prufungen, $lift, $betreiber_pdf = true)
    {
        if ( $prufungen ) {

            $user = $this->currentUser();

            if ( $lift->Type == "Spielplatzgeräte" ) {

                $gerat_mangels = GeratMangel::find()->all();
                return $content = $this->renderPartial('/pdf-base/_spielplatzgerate', ['lift' => $lift, 'prufungen' => $prufungen, 'gerat_mangels' => $gerat_mangels, 'user' => $user ]);
            }else if ( $lift->Type == "KFZ Parkeranlage" ) {

                return $content = $this->renderPartial('/pdf-base/_parkeranlagen', ['lift' => $lift, 'prufungen' => $prufungen, 'user' => $user]);
            }else if ( $lift->Type == "Arbeitsmittel" ) {

                return $content = $this->renderPartial('/pdf-base/_arbeitsmittel', ['lift' => $lift, 'prufungen' => $prufungen, 'user' => $user ]);
            }else {
                return $content = $this->renderPartial('/pdf-base/_reportView', ['lift' => $lift, 'prufungen' => $prufungen, 'user' => $user, 'betreiber_pdf' => $betreiber_pdf ]);
            }
        }else {

            return $content = $this->renderPartial('/pdf-base/_emty');
        }       
    }

	protected function returnCSS($prufungen, $lift)
	{

        if ( $prufungen ) {

            if ( $lift->Type == "Spielplatzgeräte" || $lift->Type == "KFZ Parkeranlage" || $lift->Type == "Arbeitsmittel" ) {
                
                return $css = $this->cssStyle();
            }else {

                return $css = '.pdf-header{ ol li { font-size: 10px; } }';
            }
        }else {

            return $css = $this->cssStyle();
        }		
	}

    protected function ensureUploadPDF( $model, $pdf_name, $s3_env, $betreiber_pdf = true )
    {

        if ( $model->upload_pdf == "1" ) { /*  Upload PDF, instead of generating  */

        	$url = UploadedFile::getInstance($model, 'url');

            /* PDF AND Image Name on S3 */

            if ( $url != null || $url != "" ) {
                $urlformat = $pdf_name. "_". bin2hex(openssl_random_pseudo_bytes(5)).'.'.$url->extension;
                $model->url = $urlformat;
                $model->save();
                $url->saveAs('uploads/'.$model->url);
                Yii::$app->get('s3bucket')->upload($s3_env. 'pdf/'.$model->url, 'uploads/'.$model->url);
                gc_collect_cycles();
                unlink('uploads/'.$model->url);                 
            }

        }else/*if ( $model->Art == "Wiederkehrende Überprüfung" || $model->Art == "Abnahmeprüfung" || $model->Art == "Außerordentliche Prüfung" )*/  { /*  Generate PDF   */
            
            $pdf_random_name = $pdf_name. "_". bin2hex(openssl_random_pseudo_bytes(5)). ".pdf";
            $pdf_generation =  $this->storePDFOnS3($model, $pdf_random_name, $betreiber_pdf);

            if ( $pdf_generation  ) {

                $model->url = $pdf_random_name;
                $model->save();
                Yii::$app->get('s3bucket')->upload($s3_env. 'pdf/'.$model->url, 'uploads/'.$model->url);
                gc_collect_cycles();
                unlink('uploads/'.$model->url);                    
            }
        }
        return true;
    }

    protected function storePDFOnS3($model, $pdf_random_name, $betreiber_pdf = true) {

        $lift = $model->getTehnic()->one();
        $path = "uploads/". $pdf_random_name;

        $css = $this->returnCSS($model, $lift);
        $content = $this->returnContent($model, $lift, $betreiber_pdf);

        $pdf = new \kartik\mpdf\Pdf([
            'mode' => \kartik\mpdf\Pdf::MODE_UTF8,
            'format' => \kartik\mpdf\Pdf::FORMAT_A4,
            'orientation' => \kartik\mpdf\Pdf::ORIENT_PORTRAIT,
            'destination' => \kartik\mpdf\Pdf::DEST_FILE,
            'filename' => $path,            
            'content' => $content,
            'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
            'cssInline' => $css,
            'options' => [
                'defaultheaderline' => 0,
                'title' => 'anlagendoku',
                'subject' => 'www.freieingenieure.com'
            ],
            'methods' => [
                'SetHTMLFooter'=>['<p style= "font-size: 9px; color: #808080; padding-top: 8px; text-align: center; font-weight: 100; margin-left: 45px; font-style: normal;">FI - Technisches Büro für Aufzugstechnik e.U. • www.freieingenieure.com • aufzug@freieingenieure.com • 0664 / 329 15 87</p><p style= "font-size: 9px; color: #808080; text-align: center; font-weight: 100; margin-left: 45px; font-style: normal;">Karmarschgasse 48/1, 1100 Wien • HG Wien • FN 453977 p • ATU 71260538</p>'],
            ]
        ]);

        $pdf->render();

        return true;
    }

    protected function ensureUploadImages( $images, $image_name, $model, $s3_env )
    {

        if ($images != null || $images != "") {

            foreach ($images as $key=>$image) {

                $img = new Images();

                $imageformat = $image_name. bin2hex(openssl_random_pseudo_bytes(5)).'.'.$image->extension;
                $img->review_id = $model->id;
                $img->name = $imageformat;

                if ( $model->image_description && $model->image_description[$key] != "" ) {

                    $img->description = $model->image_description[$key];
                }

                $image->saveAs('uploads/'.$imageformat);

                if ( $img->save() ) {

               #     if ( $model->getTehnic()->one()->Type == "Spielplatzgeräte"  ) {

                        $path = 'uploads/thumbnail/';
                        $size_1 = 1204;
                        $size_2 = 768;
                        $this->reduceImage($imageformat, $path, $size_1, $size_2);  /* REDUCE IMAGES */
                        Yii::$app->get('s3bucket')->upload($s3_env. 'image/'.$imageformat, 'uploads/thumbnail/'.$imageformat);
                        gc_collect_cycles();
                        unlink('uploads/'.$imageformat);
                        unlink('uploads/thumbnail/'.$imageformat); 
                #    }else {

                #        Yii::$app->get('s3bucket')->upload($s3_env. 'image/'.$imageformat, 'uploads/'.$imageformat);
                #        gc_collect_cycles();
                #        unlink('uploads/'.$imageformat);                     
                #    }

                }                  
            }
        }
        return true;
    }

    protected function ensureUploadAllgemeinerZustandImages( $images, $image_name, $model, $s3_env, $type )
    {


        if ($images != null || $images != "") {

            foreach ($images as $key=>$image) {

                $img = new PrufungenImage();

                $imageformat = $image_name. bin2hex(openssl_random_pseudo_bytes(5)).'.'.$image->extension;
                $img->tehnic_review_id = $model->id;
                $img->url = $imageformat;
                $img->Type = $type;

                $image->saveAs('uploads/'.$imageformat);

                if ( $img->save() ) {

               #     if ( $model->getTehnic()->one()->Type == "Spielplatzgeräte"  ) {

                        $path = 'uploads/thumbnail/';
                        $size_1 = 1204;
                        $size_2 = 768;
                        $this->reduceImage($imageformat, $path, $size_1, $size_2);  /* REDUCE IMAGES */
                        Yii::$app->get('s3bucket')->upload($s3_env. 'image/'.$imageformat, 'uploads/thumbnail/'.$imageformat);
                        gc_collect_cycles();
                        unlink('uploads/'.$imageformat);
                        unlink('uploads/thumbnail/'.$imageformat); 
                #    }else {

                #        Yii::$app->get('s3bucket')->upload($s3_env. 'image/'.$imageformat, 'uploads/'.$imageformat);
                #        gc_collect_cycles();
                #        unlink('uploads/'.$imageformat);                     
                #    }

                }                  
            }
        }
        return true;
    }

    protected function ensureUploadDocuments( $documents, $document_name, $id, $s3_env )
    {

        if ($documents != null || $documents != "") {

            foreach ($documents as $key=>$document) {

                $model = new TehnicalDocument();
                $model->tehnical_id = $id;
                $documentformat = $document_name. bin2hex(openssl_random_pseudo_bytes(8)).'.'.$document->extension;
                $model->url = $documentformat;
                $model->name = $document->name;
                $document->saveAs('uploads/'.$documentformat);

                if ( $model->save() ) {

                    Yii::$app->get('s3bucket')->upload($s3_env. 'documents/'.$model->url, 'uploads/'.$model->url);
                    gc_collect_cycles();
                    unlink('uploads/'.$model->url);
                }                  
            }
        }
        return true;
    }

    protected function ensureUploadGeratImages( $gerat_images, $image_name, $model, $s3_env )
    {

        if ($gerat_images != null || $gerat_images != "") {

            foreach ($gerat_images as $key=>$image) {

                $img = new Images();

                $imageformat = $image_name. bin2hex(openssl_random_pseudo_bytes(5)).'.'.$image->extension;

                $img->review_id = $model->id;
                $img->gerat_image = $imageformat;

                if ( $model->gerat && $model->gerat[$key] != "" ) {

                    $img->gerat = $model->gerat[$key];
                }

                if ( $model->gerat_mangel && $model->gerat_mangel[$key] != "" ) {

                    $img->gerat_mangel = $model->gerat_mangel[$key];;
                }

                if ( $model->gerat_mangel_type && $model->gerat_mangel_type[$key] != "" ) {

                    $gerat_mangel = GeratMangel::find()->where(['name' => $model->gerat_mangel_type[ $key ]])->one();
                    $img->gerat_mangel_type = $gerat_mangel->status;
                }

                if ( $img->save() ) {

                    $image->saveAs('uploads/'.$imageformat);

                    $path = 'uploads/thumbnail/';
                    $size_1 = 1204;
                    $size_2 = 768;
                    $this->reduceImage($imageformat, $path, $size_1, $size_2);  /* REDUCE IMAGES */

                    Yii::$app->get('s3bucket')->upload($s3_env. 'image/'.$imageformat, 'uploads/thumbnail/'.$imageformat);
                    gc_collect_cycles();
                    unlink('uploads/'.$imageformat);
                    unlink('uploads/thumbnail/'.$imageformat);
                }                  
            }
        }
        return true;
    }
    
    protected function ensureUploadMangelImages( $mangel_images, $image_name, $model, $s3_env, $mangelsInputArray, $mangelConstruct )
    {
        $imageKay = array();

        foreach ($mangel_images as $key=>$image) {
            $imageKay[$image->name] = $image;
        }

        foreach ($mangelsInputArray as $key=>$mangel) {

            if( $mangel->deleted == 0 ) {

                $this->ensureFirstInDatabase($mangel->frist);
                $this->ensureMangelPropertiesInDatabase($mangel->mangel);

                if(isset($mangel->al)) {
                    $this->ensureAlPropertiesInDatabase($mangel->al);
                }

                $mangelConstruct= new Magel(); 
                $mangelConstruct->mangel = $mangel->mangel;
                $mangelConstruct->frist = $mangel->frist;
                $mangelConstruct->tehnic_review_id_integer = $model->id;

                if(isset($mangel->al)) {
                    $mangelConstruct->al = $mangel->al;
                }

                $mangelConstruct->type = $mangel->type;

                if($mangel->file != "") {
                    $document = $imageKay[$mangel->file];
                    $imageformat = $image_name. bin2hex(openssl_random_pseudo_bytes(5)).'.'.$document->extension;
                    $mangelConstruct->photo = $imageformat;
                }

                if ( $mangelConstruct->save() && $mangel->file != "" ) {

                    $document->saveAs('uploads/'.$imageformat);

                    $path = 'uploads/thumbnail/';
                    $size_1 = 1204;
                    $size_2 = 768;
                    $this->reduceImage($imageformat, $path, $size_1, $size_2);  /* REDUCE IMAGES */

                    Yii::$app->get('s3bucket')->upload($s3_env. 'image/'.$imageformat, 'uploads/thumbnail/'.$imageformat);
                    gc_collect_cycles();
                    unlink('uploads/'.$imageformat);
                    unlink('uploads/thumbnail/'.$imageformat);
                }   

            }               
        }
        return true;
    }

    protected function ensureFirstInDatabase($fristName) {
        $fristExist = Frist::find()->where(['name' => $fristName])->one();

        if(!$fristExist) {
            $frist = new Frist();
            $frist->name = $fristName;
            $frist->save();
        }
        return true;
    }

    protected function ensureMangelPropertiesInDatabase($mangel) {
        $data = MangelProperties::find()->where(['name' => $mangel])->one();

        if(!$data) {
            $man = new MangelProperties();
            $man->name = $mangel;
            $man->save();
        }
        return true;
    }

    protected function ensureAlPropertiesInDatabase($name) {
        $alPropertiesExist = AlProperties::find()->where(['name' => $name])->one();

        if(!$alPropertiesExist) {
            $alProperties = new AlProperties();
            $alProperties->name = $name;
            $alProperties->save();
        }
        return true;
    }

    protected function reduceImage($imageformat, $path, $size_1, $size_2)
    {

        $imagine = Image::getImagine();

        $image_thumb = $imagine->open('uploads/' . $imageformat);
        $image_thumb->resize(new Box( $size_1, $size_2 ))->save($path . $imageformat, ['quality' => 70]);
    }

    protected function ensureImageformatName($model)
    {
        $anlagen = $model->getTehnic()->one();
        $date_for_pdf = str_replace('.', '-', $model->datum);
        $analgen_nr_for_pdf = "AT".$model->tehnic_id;
        $art_for_pdf = str_replace(' ', '_', $model->Art);
        $full_adress_for_pdf = str_replace(' ', '_', $anlagen->AdressePLZ). "_". str_replace(' ', '_', $anlagen->AdresseOrt). "_".str_replace(' ', '_', $anlagen->AdresseStreat). "_".str_replace(' ', '_', $anlagen->Zusatz);
        $full_adress_for_pdf = str_replace('/', '_', $full_adress_for_pdf);

        $prufungsdatum_for_pdf = date("Y-m-d", strtotime($model->Prufungsdatum));
      //  $prufungsdatum_for_pdf = str_replace('.', '-', $model->Prufungsdatum);

        if ( $model->Prufungsdatum != null || $model->Prufungsdatum != "" ) {

            $image_name = $prufungsdatum_for_pdf. "_". $analgen_nr_for_pdf. "_". $art_for_pdf. "_". $full_adress_for_pdf;

            return $this->covertGermanCharacther($image_name);
        }else {

            $image_name = $date_for_pdf. "_". $analgen_nr_for_pdf. "_". $art_for_pdf. "_". $full_adress_for_pdf;

            return $this->covertGermanCharacther($image_name);
        }
    }


    protected function ensureDocumentformatName($anlagen)
    {   
        $date = date("Y.m.d");
        $date_for_pdf = str_replace('.', '-', $date);
        $analgen_nr_for_pdf = "AT".$anlagen->id;
        $rnd = bin2hex(openssl_random_pseudo_bytes(5));

        $image_name = $date_for_pdf. "_". $analgen_nr_for_pdf. "_". $rnd;

            return $this->covertGermanCharacther($image_name);
    }

    protected function covertGermanCharacther($variable)
    {

        $variable = str_replace('Ü', 'Ue', $variable);
        $variable = str_replace('ü', 'ue', $variable);

        $variable = str_replace('Ä', 'Ae', $variable);
        $variable = str_replace('ä', 'ae', $variable);

        $variable = str_replace('Ö', 'Oe', $variable);
        $variable = str_replace('ö', 'oe', $variable);

        $variable = str_replace('ẞ', 'ss', $variable);
        $variable = str_replace('ß', 'Ss', $variable);

        return $variable;
    }


    protected function ensurePDFformatName($model)
    {
      //  $art = Art::find()->where(['name' => $model->Art])
        $anlagen = $model->getTehnic()->one();
        $date_for_pdf = str_replace('.', '-', $model->datum);
        $analgen_nr_for_pdf = "AT".$model->tehnic_id;
        $art_for_pdf = str_replace(' ', '_', $model->Art);
        $full_adress_for_pdf = str_replace(' ', '_', $anlagen->AdressePLZ). "_". str_replace(' ', '_', $anlagen->AdresseOrt). "_".str_replace(' ', '_', $anlagen->AdresseStreat). "_".str_replace(' ', '_', $anlagen->Zusatz);
        $full_adress_for_pdf = str_replace('/', '_', $full_adress_for_pdf);

        $prufungsdatum_for_pdf = date("Y-m-d", strtotime($model->Prufungsdatum));
      //  $prufungsdatum_for_pdf = str_replace('.', '-', $model->Prufungsdatum);

        if ( $model->Prufungsdatum != null || $model->Prufungsdatum != "" ) {

            $name = $prufungsdatum_for_pdf. "_". $analgen_nr_for_pdf. "_". $art_for_pdf. "_". $full_adress_for_pdf;
            $name = $this->covertGermanCharacther($name);
            return $name;
        }else {
            $name = $date_for_pdf. "_". $analgen_nr_for_pdf. "_". $art_for_pdf. "_". $full_adress_for_pdf;
            $name = $this->covertGermanCharacther($name);
            return $name;
        }
    }

    protected function ensureUpdateTehnicalDate($model)
    {
        $anlagen_LetzteDate = $model->getTehnic()->one();

        if ( $model->IsWiederkehrendeUberprufung() ) {

            $newDate = date("d-m-Y", strtotime($model->Prufungsdatum));
            $newDate = str_replace("-",".", $newDate);
            $anlagen_LetzteDate->LetzteDate = $newDate;
            $anlagen_LetzteDate->Letzte = "FI";
        }

        $anlagen_LetzteDate->new_prufungen_date = $model->datum;
        $time = new DateTime('now', new DateTimeZone('UTC'));

        $anlagen_LetzteDate->new_prufungen_date_time = $time->format('y-m-d H:i:s');
        $anlagen_LetzteDate->save();          
    }

	protected function deleteFromS3PDF($url, $env)
    {   
        $env = $env;
        if ($url) {
            Yii::$app->get('s3bucket')->delete($env. 'pdf/'.$url);
        }
    }

    protected function deleteFromS3Image($images, $env)
    {
        $env = $env;

        foreach ($images as $key => $image) {

            if ( $image && isset($image->name) && $image->name ) {

                Yii::$app->get('s3bucket')->delete($env. 'image/'.$image->name);
            }elseif ( $image && isset($image->gerat_image) && $image->gerat_image ) {

                Yii::$app->get('s3bucket')->delete($env. 'image/'.$image->gerat_image);   
            }elseif ( $image && isset($image->url) && $image->url ) {

                Yii::$app->get('s3bucket')->delete($env. 'image/'.$image->url);   
            }
        }
    }

    protected function deleteFromDatabaseImage($images)
    {

        foreach ($images as $key => $image) {

            $image->delete();
        }        
    }

    protected function removeAllCheckedImages($model, $s3_env)
    {

        $all_images = $model->destroy_images;
        $to_remove = array('0');

        if ( $all_images ) {

            $images_ids = array_diff($all_images, $to_remove);
        }else {

            $images_ids = null;
        }

        if ( $images_ids ) {

            $images = [];

            foreach ($images_ids as $key => $image_id) {
                
                $image = Images::findOne($image_id);

                array_push($images, $image);
            }

            $this->deleteFromS3Image($images, $s3_env);
            $this->deleteFromDatabaseImage( $images );
        }
        return true;
    }


    protected function removeAllCheckedAllgemeinerZustandImages($model, $s3_env)
    {

        $all_images = $model->destroyAllgemeinerZustandImages;
        $to_remove = array('0');


        if ( $all_images ) {
            $images_ids = array_diff($all_images, $to_remove);
        }else {
            $images_ids = null;
        }

        if ( $images_ids ) {

            $images = [];

            foreach ($images_ids as $key => $image_id) {
                
                $image = PrufungenImage::findOne($image_id);

                array_push($images, $image);
            }

            $this->deleteFromS3Image($images, $s3_env);
            $this->deleteFromDatabaseImage( $images );
        }
        return true;
    }

    protected function removeAllCheckedAllWartungsbuchImages($model, $s3_env) {
        $all_images = $model->destroyAllWartungsbuch;
        $to_remove = array('0');

        if ( $all_images ) {
            $images_ids = array_diff($all_images, $to_remove);
        }else {
            $images_ids = null;
        }

        if ( $images_ids ) {

            $images = [];

            foreach ($images_ids as $key => $image_id) {
                
                $image = PrufungenImage::findOne($image_id);

                array_push($images, $image);
            }

            $this->deleteFromS3Image($images, $s3_env);
            $this->deleteFromDatabaseImage( $images );
        }
        return true;        
    }

    public function strucutreMangales($mangelsInputArray) {
       

        $retData = [
            '1' => [
                'arrayOfAl' => [],
                'mangels' => [],
                'numberOFMangel' => 0,
                'numberOfFrist' => 0,
                'arrayOfFristNumbers' => [],
                'arrayOfFrists' => []
            ],
            '0' => [
                'arrayOfAl' => [],
                'mangels' => [],
                'numberOFMangel' => 0,
                'numberOfFrist' => 0,
                'arrayOfFristNumbers' => [],
                'arrayOfFrists' => []
            ] 
        ];

        foreach ($mangelsInputArray as $key => $value) {
            if($value->mangel != "") {
                $retData[$value->type]['numberOFMangel'] += 1;
                array_push($retData[$value->type]['mangels'], $value->mangel);
            }
        }

        foreach ($mangelsInputArray as $key => $mangel) {
            $retData[$mangel->type]['arrayOfFristNumbers'][$mangel->frist] = array();
        }

        $indexByType = [
            '0' => 0,
            '1' => 0,
        ];

        foreach ($mangelsInputArray as $key => &$mangel) {

            if( $mangel->frist != "" && $mangel->frist != null ) {
                $indexByType[$mangel->type] += 1;
                array_push($retData[$mangel->type]['arrayOfFrists'], $mangel->frist);
                array_push($retData[$mangel->type]['arrayOfFristNumbers'][$mangel->frist], $indexByType[$mangel->type]);
            }

            if($mangel->type == 1 && $mangel->al != "" && $mangel->al != null) {
                array_push($retData[$mangel->type]['arrayOfAl'], $mangel->al);
            }
        }

        $retData['0']['arrayOfFrists'] = array_unique($retData['0']['arrayOfFrists']);
        $retData['1']['arrayOfFrists'] = array_unique($retData['1']['arrayOfFrists']);

        $resultOfFrists = [];
        foreach ($retData['0']['arrayOfFrists'] as $key => $frist) {
            $frist = implode(",",$retData['0']['arrayOfFristNumbers'][$frist]). ")" .$frist ."  ";
            array_push($resultOfFrists, $frist);
        }
        $retData['0']['numberOfFrist'] = count($resultOfFrists);
        $retData['0']['arrayOfFrists'] = array_unique($resultOfFrists);

        $resultOfFrists = [];
        foreach ($retData['1']['arrayOfFrists'] as $key => $frist) {
            $frist = implode(",",$retData['1']['arrayOfFristNumbers'][$frist]). ")" .$frist ."  ";
            array_push($resultOfFrists, $frist);
        }
        $retData['1']['numberOfFrist'] = count($resultOfFrists);
        $retData['1']['arrayOfFrists'] = array_unique($resultOfFrists);
        
        return $retData;
    }

    protected function cssStyle()
    {
        return $css='

            @page {

                size: auto;
                margin-header: 60px;
                margin-footer: 5mm;
                margin-top: 130px; 
                odd-header-name: html_myHeader1;
                odd-footer-name: html_myFooter1;
                position: relative;
                font-family: Helvetica, arial, sans-serif;
            }
 
            @page chapter2 {

                odd-header-name: html_Chapter2HeaderOdd;
                odd-footer-name: html_Chapter2FooterOdd;
                margin-top: 140px;
                font-family: Helvetica, arial, sans-serif;
            }

            div.chapter2 {
                page-break-before: right;
                page: chapter2;
                margin-top: 150px; 
            }

        
            div.onitsside { 
                page: rotated; 
                page-break-before: right;
            }

            .pdf-left-margin {

                margin-left: 40px;
            }

            .page-break {

                page-break-after: always;
            }

            .content-first-page {

                margin-top: 50px;
            }

            .content-first-page-parkeranlagen {

                margin-top: 10px;
            }

            .content-first-page .first-table tr td {

                padding-right: 5px;
            }

            .table-first-row {

                width: 150px;
            }

            .table-first-page-second-row {

                width: 80px;
            }

            .table-first-page-third-row {

                width: 50px;
            }

            .table-first-page-third-row-result {

                width: 130px;
            }

            .second-table {

                margin-top: 30px;
            }

            .third-table {

                margin-top: 50px;
            }

            .third-table-parkeranlagen {

                margin-top: 25px;
            }

            .third-table-arbeitsmittel {

                margin-top: 10px;
            }

            .table-baujahr-print {

                width: 155px;
            }

            .box-information {

                height: 55%;
                max-height: 55%;
                overflow: hidden;
                margin-top: 40px;
            }

            .prufungen-text {

                width: 100%; 
                height: 180px; 
                min-height: 180px; 
                max-height: 180px; 
                border: 2px solid #000000; 
                padding: 5px 11px 0 15px;
                border-bottom: 0; 
                overflow: hidden;
            }

            .prufungen-text-first-paragraph {

                font-size: 14px; 
                font-weight: 400; 
                color: #000000; 
                padding-top: 0; 
                padding-bottom: 0; 
                margin-top: 0; 
                margin-bottom: 0; 
            }

            .prufungen-text-second-paragraph {

                font-size: 13px; 
                font-weight: 100; 
                color: #000000; 
                padding-top: 0; 
                padding-bottom: 0; 
                margin-top: 0; 
                margin-bottom: 0; 
                padding-left: 3px; 
            }

            .prufungen-text div {

                font-size: 13px; 
                font-weight: 100; 
                color: #000000; 
                padding:0;
            }

            .amnerkugen-box {

                width: 99%; 
                height: 50px; 
                border-left: 2px solid #000000; 
                border-right: 2px solid #000000; 
                border-top: 0; 
                border-bottom: 2px solid #000000; 
                padding-left: 10px; 
                padding-right: 10px; 
                margin-top: -1px; 
                font-size: 13px; 
                font-weight: 100; 
            }

            .massage-information {

                margin-top: 30px;
            }

            .table-stamp {

                width: 100%;
                margin-top: 10px;
            }

            .table-stamp tr .table-stamp-first-column {

                width: 65%; 
                padding-top: 10px; 
                font-size: 13px;
            }

            .table-stamp tr .stamp-place {

                height: 100px;
            }

            .pdf-foothill {

                margin-top: 30px;
            }

            .pdf-foothill p {

                font-size: 10px;
                font-weight: 800; 
                padding-top: 5px;
            }
         
            .pdf-section-wrapper {

                margin-right: 35px;
            }

            .Inspektionsobjekt-header {

                margin-top: -40px;
            }

            .title-bold-print {

                font-size: 13px;
                font-weight: bold;
                color: #000000;
            }

            .title-bold {

                font-size: 13px; 
                font-weight: 100; 
                color: #000000;
            }

            .pdf-lift-type-title {

                font-size: 18px;
            }

            .pdf-section3-wrapper-title {

                font-size: 13px;
                font-weight: bold;
                color: #000000;
                margin-top: -75px;
                margin-left: -10px; 
                text-decoration: underline;            
            }

            .pdf-section3-wrapper-sub-title {

                font-size: 13px; 
                font-weight: 100; 
                color: #000000;
                margin-top: 15px;
            }

            .pdf-table {

                margin-top: 60px;
            }

            .pdf-table tr {

            }

            .pdf-table-size-field {

                height: 100%;
            }

            .pdf-table,
            .pdf-table-description,
            .pdf-table-image {

                border: 1px solid #000000;
                border-collapse: collapse;
            }

            thead .pdf-title-header {

                padding: 18px;
                font-size: 18px;
            }

            thead .pdf-title-header-left {

                border-right: 1px solid #000000;
            }

            .pdf-table tbody tr td {

                font-size: 20px;
            }

            .pdf-table-description {

                width: 40%;
                padding: 15px;
                font-size: 18px;
                font-family: Helvetica, arial, sans-serif;
            }

            .pdf-table-image {

                width: 60%;
                padding: 15px;
                text-align: center;
            }

            .table-first-section3 {

                border-collapse: collapse;
                margin-top: 25px;
            }

            .table-first-section3 tr td {

                border: 1px solid #000000;
            }

            .table-first-section3-first-child {

                width: 50px;
                text-align: center;
            }

            .table-second-section3 {

                border-collapse: collapse;
                margin-top: 30px;
            }

            .table-second-section3 tr td {

                border: 1px solid #000000;
                padding: 30px;
            }

            .table-second-section3-first-row {

                max-height: 900px;
                min-height: 900px;
            }

            .table-second-section3-first-column {

                width: 5%;
                max-width: 5%;
                text-align: center;
            }

            .table-second-section3-second-column {

                width: 20%;
                max-width: 20%;
            }

            .table-second-section3-third-column {

                width: 60%;
                max-width: 60%;
                text-align: center;
            }

            .second-section3-third-column-empty-box {

                width: 100%;
            }

            .table-second-section3-forth-column {

                width: 15%;
                max-width: 15%;
                text-align: center;
            }

            .table-second-section3-title {

                font-size: 46px;
                font-family: Helvetica, arial, sans-serif;
                font-weight: 500;
            }


            .table-second-section3-header-title {

                font-size: 44px;
                font-family: Helvetica, arial, sans-serif;
                font-weight: bold;
            }

            .emty-container {

                display: table;
                text-align: center;
                border: 2px dashed #fff;
                width: 100%;
                height: 100%;
            }

            .emty-container h1 {

                display: table-cell;
                vertical-align: middle;
                margin-top: 200px;
            }

        ';
    }
}