<?php

namespace backend\controllers;

use Yii;
use common\models\MangelProperties;
use yii\data\Pagination;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * MangelPropertiesController implements the CRUD actions for MangelProperties model.
 */
class MangelPropertiesController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        if ($this->currentUser() && $this->currentUser()->role_id != "1") {
            $this->redirect(['site/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all MangelProperties models.
     * @return mixed
     */
    public function actionIndex()
    {

        $query = MangelProperties::find();
        $count = $query->count();

        $pagination = new Pagination([
            'defaultPageSize' => 20,
            'totalCount' => $count,
        ]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => ['pageSize' => 20],
        ]);

        $desktop = $this->isDesktop();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'desktop' => $desktop,
            'pagination' => $pagination,
        ]);
    }

    /**
     * Displays a single MangelProperties model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $desktop = $this->isDesktop();
        return $this->render('view', [
            'model' => $this->findModel($id),
            'desktop' => $desktop
        ]);
    }

    /**
     * Creates a new MangelProperties model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new MangelProperties();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing MangelProperties model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing MangelProperties model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the MangelProperties model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return MangelProperties the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = MangelProperties::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
