<?php

namespace backend\controllers;

use Yii;
use common\models\Magel;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\web\Response;
use common\models\TehnicReview;

/**
 * MangelController implements the CRUD actions for Magel model.
 */
class MangelController extends PdfBaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Magel models.
     * @return mixed
     */
    public function actionIndex()
    {
        $dataProvider = new ActiveDataProvider([
            'query' => Magel::find(),
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Magel model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Magel model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Magel();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Magel model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $tehnic_review = TehnicReview::findOne($model->tehnic_review_id_integer);
        $s3_env = S3_ENV;

        if ($model->load(Yii::$app->request->post())) {


        $file = UploadedFile::getInstance($model, 'photo');

        if($file) {
            $image_name = $this->ensureImageformatName($tehnic_review). bin2hex(openssl_random_pseudo_bytes(5));

            $imageformat = $image_name.'.'.$file->extension;

            $file->saveAs('uploads/'.$imageformat);

            $path = 'uploads/thumbnail/';
            $size_1 = 1204;
            $size_2 = 768;
            $this->reduceImage($imageformat, $path, $size_1, $size_2);  /* REDUCE IMAGES */


            Yii::$app->get('s3bucket')->upload($s3_env. 'image/'.$imageformat, 'uploads/thumbnail/'.$imageformat);
            gc_collect_cycles();
            unlink('uploads/'.$imageformat);
            unlink('uploads/thumbnail/'.$imageformat);
        }else {

            $imageformat = $model->OldAttributes['photo'];
        }


        $model->photo = $imageformat;
        $model->save();

            return $this->redirect(['tehnic-review/update', 'id' => $model->tehnic_review_id_integer, 'editedMangel' => true]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Magel model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Magel model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Magel the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Magel::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
