<?php

namespace backend\controllers;

use Yii;
use common\models\InvoiceData;
use common\models\search\InvoiceDataSearch;
use common\models\Tehnical;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * InvoiceDataController implements the CRUD actions for InvoiceData model.
 */
class InvoiceDataController extends Controller
{

    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    protected function ensureinvoceData($model) {
        $data = InvoiceData::find()->where(['KundenNr' => $model->KundenNr])->one();

        var_dump($model->KundenNr);
        if($data) {
            $test = true;
        }else {
            $test = false;
        }

        var_dump($test);
        var_dump("----------------------------------");      

        if(!$data) {
            $data = new InvoiceData();
            $data->KundenNr = $model->KundenNr;
            $data->Kunden_Rechnungszusatz = $model->Kunden_Rechnungszusatz;
            $data->Kunden_Strase = $model->Kunden_Straße;
            $data->Kunden_PLZ = $model->Kunden_PLZ;
            $data->Kunden_Ort = $model->Kunden_Ort;
            $data->Kunden_Referenzzeilec = $model->Kunden_Referenzzeile;
            $data->Kunden_Rechnungsemail = $model->Kunden_Rechnungsemail;
            $data->save();
        }
        return true;
    }

    /**
     * Lists all InvoiceData models.
     * @return mixed
     */
    public function actionAdd()
    {

        $anlagens = Tehnical::find()->all();

        foreach ($anlagens as $key => $anlagen) {

            $this->ensureinvoceData($anlagen);
        }


        var_dump("---completed");


        die;

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Lists all InvoiceData models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new InvoiceDataSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single InvoiceData model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new InvoiceData model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new InvoiceData();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing InvoiceData model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {

            $old_KundenNr = $model->OldAttributes['KundenNr'];
            $anglagens = Tehnical::find()->where(['KundenNr' => $old_KundenNr])->all();

            foreach ($anglagens as $key => $anlagen) 
            {
                $anlagen->Kunden_Rechnungszusatz = $model->Kunden_Rechnungszusatz;
                $anlagen->Kunden_Straße = $model->Kunden_Strase;
                $anlagen->Kunden_PLZ = $model->Kunden_PLZ;
                $anlagen->Kunden_Ort = $model->Kunden_Ort;
                $anlagen->Kunden_Referenzzeile = $model->Kunden_Referenzzeilec;
                $anlagen->Kunden_Rechnungsemail = $model->Kunden_Rechnungsemail;
                $anlagen->KundenNr = $model->KundenNr;
                $anlagen->save();
            }

            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing InvoiceData model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the InvoiceData model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return InvoiceData the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = InvoiceData::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
