<?php

namespace backend\controllers;

    use Yii;
    use Closure;
    use yii\i18n\Formatter;
    use yii\base\InvalidConfigException;
    use yii\helpers\Url;
    use yii\helpers\Html;
    use yii\helpers\Json;
    use yii\helpers\ArrayHelper;
    use yii\widgets\BaseListView;
    use yii\base\Model;
    use common\models\User;
    use \PHPExcel;
    use \PHPExcel_IOFactory;
    use \PHPExcel_Settings;
    use \PHPExcel_Style_Fill;
    use \PHPExcel_Writer_IWriter;
    use \PHPExcel_Worksheet;
    use \PHPExcel_Style_Alignment;
    use \PHPExcel_Style_Border;
    use common\models\Tehnical;
    use common\models\Wartungsfirma;
    use DateTime;
    use DateTimeZone;
/**
 * AdminController implements the CRUD actions for User model.
 */
class InvoiceController extends ExportBaseController
{


    public function actionDownload()
    {
        $excel_props = array('creator' => 'Anlagendoku Application'
        , 'title' => 'Anlagendoku'
        , 'subject' => 'http://www.anlagendoku.com export data'
        , 'desc' => 'Freie-ingenieure data export excel'
        , 'keywords' => 'WWSP Tool Generated Excel, Author: Belmir Hamidovic'
        , 'category' => 'Freie-ingenieure data export excel');

            
        $tehnicals = Tehnical::find()->all();
        $lastRow = count($tehnicals);

        $objPHPExcel = new PHPExcel();
        $objProps = $objPHPExcel->getProperties();
        $objProps->setCreator($excel_props['creator']);
        $objProps->setLastModifiedBy($excel_props['creator']);
        $objProps->setTitle($excel_props['title']);
        $objProps->setSubject($excel_props['subject']);
        $objProps->setDescription($excel_props['desc']);
        $objProps->setKeywords($excel_props['keywords']);
        $objProps->setCategory($excel_props['category']);

        if ( count($tehnicals) > 0 ) {

            $sheet_index = 0;
            $sheet_title = "Kunden";        
            $this->ensureSheetWithData($tehnicals, $sheet_index, $sheet_title, $objPHPExcel );
        }

        $filename="import_orgamax".'.xlsx'; //just some random filename
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'.$filename.'"');
        header('Cache-Control: max-age=0');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007'); 
        $objWriter->save('php://output');
        return $this->redirect('/tehnical/index');
    }

    protected function ensureSheetWithData( $tehnicals, $sheet_index, $sheet_title, $objPHPExcel )
    {

        $objPHPExcel->createSheet();
        $objPHPExcel->setActiveSheetIndex( $sheet_index );

        $sheet = $objPHPExcel->getActiveSheet();
        $sheet->setTitle( $sheet_title );

        //////////////////////////////////////////////// DATA EXPORT
        $this->dataInitialize($sheet, $tehnicals, $sheet_title);
        $this->headerInitialize($sheet, $tehnicals, $sheet_title);
        /////////////////////////////////////////////////////
        $this->ensureSheetStyle($sheet, $tehnicals, $sheet_title);
        $this->ensureInvoiceSheetSize($sheet);
    }

    protected function dataInitialize( $sheet, $tehnicals, $sheet_title )
    {
        $Bezeichnung = "[Rechnung]wiederkehrende Überprüfung[/Rechnung], <P_A_INDIVIDUAL2>\r <P_A_INDIVIDUAL3> <P_A_INDIVIDUAL4>, <P_A_INDIVIDUAL5>\r <P_A_INDIVIDUAL6>    FbNr.: <P_A_INDIVIDUAL7>";

        foreach ($tehnicals as $key => $tehnic) {

            $row = 1 + $key + 1;
            $anlagen_type = $this->anlagenType($tehnic);

            $sheet->SetCellValue( 'A'.$row, 'AT'.$tehnic->id );
            $sheet->SetCellValue( 'B'.$row, $Bezeichnung );
            $sheet->SetCellValue( 'C'.$row, $tehnic->Fakturenadresse );
            $sheet->SetCellValue( 'D'.$row, $tehnic->PreisWP  );
            $sheet->SetCellValue( 'E'.$row, $tehnic->LetzteDate  ); 
            $sheet->SetCellValue( 'F'.$row, $anlagen_type  ); 
            $sheet->SetCellValue( 'G'.$row, $tehnic->AdressePLZ  ); 
            $sheet->SetCellValue( 'H'.$row, $tehnic->AdresseOrt  ); 
            $sheet->SetCellValue( 'I'.$row, $tehnic->AdresseStreat  );
            $sheet->SetCellValue( 'J'.$row, $tehnic->Zusatz  );
            $sheet->SetCellValue( 'K'.$row, $tehnic->FabriksNr  );
            $sheet->SetCellValue( 'L'.$row, $tehnic->ObjektNr );
            $sheet->SetCellValue( 'M'.$row,  $tehnic->KundenNr );
            $sheet->SetCellValue( 'N'.$row, $tehnic->Fakturenadresse  );
            $sheet->SetCellValue( 'O'.$row,  $tehnic->Kunden_Rechnungszusatz );
            $sheet->SetCellValue( 'P'.$row,  $tehnic->Kunden_Straße );
            $sheet->SetCellValue( 'Q'.$row,  $tehnic->Kunden_PLZ );
            $sheet->SetCellValue( 'R'.$row,  $tehnic->Kunden_Ort );
            $sheet->SetCellValue( 'S'.$row, $tehnic->ObjektNr );
            $sheet->SetCellValue( 'T'.$row,  $tehnic->Kunden_Referenzzeile );
            $sheet->SetCellValue( 'U'.$row, $tehnic->UIDNUMMER  );
            $sheet->SetCellValue( 'V'.$row, $tehnic->Hausverwalter  ); 
            $sheet->SetCellValue( 'W'.$row, $tehnic->HausverwalterEmail  ); 
            $sheet->SetCellValue( 'X'.$row, $tehnic->KontaktVerwalter  );
            $sheet->SetCellValue( 'Y'.$row, $tehnic->Kunden_Rechnungsemail  );
        }
    }

    protected function headerInitialize( $sheet, $tehnicals, $sheet_title )
    {

        $sheet->SetCellValue('A1', 'Anlagen Nr');
        $sheet->SetCellValue('B1', 'Bezeichnung');
        $sheet->SetCellValue('C1', 'Fakturenadresse');
        $sheet->SetCellValue('D1', 'Preis WP');
        $sheet->SetCellValue('E1', 'Prüfungsdatum');
        $sheet->SetCellValue('F1', 'Type');
        $sheet->SetCellValue('G1', 'PLZ');
        $sheet->SetCellValue('H1', 'ORT');
        $sheet->SetCellValue('I1', 'ADRESSE');
        $sheet->SetCellValue('J1', 'Zusatz');
        $sheet->SetCellValue('K1', 'Fabriks Nr');
        $sheet->SetCellValue('L1', 'Objekt Nr.');
        $sheet->SetCellValue('M1', 'KundenNr.');
        $sheet->SetCellValue('N1', 'Fakturenadresse');
        $sheet->SetCellValue('O1', 'Kunden_Rechnungszusatz');
        $sheet->SetCellValue('P1', 'Kunden_Straße');
        $sheet->SetCellValue('Q1', 'Kunden_PLZ ');
        $sheet->SetCellValue('R1', 'Kunden_Ort');
        $sheet->SetCellValue('S1', 'Objekt Nr.');
        $sheet->SetCellValue('T1', 'Kunden_Referenzzeile');
        $sheet->SetCellValue('U1', 'UID NUMMER');
        $sheet->SetCellValue('V1', 'Hausverwalter');
        $sheet->SetCellValue('W1', 'Hausverwalter Email');
        $sheet->SetCellValue('X1', 'Kontakt Verwalter');
        $sheet->SetCellValue('Y1', 'Kunden_Rechnungsemail');
        $sheet->SetCellValue('Z1', '');
        $sheet->SetCellValue('AA1', '');
        $sheet->SetCellValue('AB1', '');
        $sheet->SetCellValue('AC1', '');
        $sheet->SetCellValue('AD1', '');
        $sheet->SetCellValue('AE1', '');
        $sheet->SetCellValue('AF1', '');
        $sheet->SetCellValue('AG1', '');
        $sheet->SetCellValue('AH1', '');
        $sheet->SetCellValue('AI1', '');
        $sheet->SetCellValue('AJ1', '');
        $sheet->SetCellValue('AK1', '');
        $sheet->SetCellValue('AL1', '');
        $sheet->SetCellValue('AM1', '');
        $sheet->SetCellValue('AN1', '');
        $sheet->SetCellValue('AO1', '');
        $sheet->SetCellValue('AP1', '');
        $sheet->SetCellValue('AQ1', '');
        $sheet->SetCellValue('AR1', '');
        $sheet->SetCellValue('AS1', '');
        $sheet->SetCellValue('AT1', '');
        $sheet->SetCellValue('AU1', '');
        $sheet->SetCellValue('AV1', '');
        $sheet->SetCellValue('AW1', '');
        $sheet->SetCellValue('AX1', '');
        $sheet->SetCellValue('AY1', '');
    }

    protected function ensureSheetStyle( $sheet, $tehnicals, $sheet_title )
    {

        $light_brown = $this->styleHeaderInvoiceTitleLightBrowun();
        $brown = $this->styleHeaderInvoiceTitleBrowun();
        $light_blue = $this->styleHeaderInvoiceColor();
        $default = $this->styleDefaultColorAndAlignCenter();
        $styleHeaderPreisWP = $this->styleHeaderPreisWP();
        $align_text = $this->align_text_stylesheetInitialize();

        $sheet->getStyle('A')->applyFromArray($align_text);
        $sheet->getStyle('B')->applyFromArray($align_text);
        $sheet->getStyle('C')->applyFromArray($align_text);
        $sheet->getStyle('D')->applyFromArray($align_text);
        $sheet->getStyle('E')->applyFromArray($align_text);
        $sheet->getStyle('F')->applyFromArray($align_text);
        $sheet->getStyle('G')->applyFromArray($align_text);
        $sheet->getStyle('H')->applyFromArray($align_text);
        $sheet->getStyle('I')->applyFromArray($align_text);
        $sheet->getStyle('J')->applyFromArray($align_text);
        $sheet->getStyle('K')->applyFromArray($align_text);
        $sheet->getStyle('L')->applyFromArray($align_text);
        $sheet->getStyle('M')->applyFromArray($align_text);
        $sheet->getStyle('N')->applyFromArray($align_text);
        $sheet->getStyle('O')->applyFromArray($align_text);
        $sheet->getStyle('P')->applyFromArray($align_text);
        $sheet->getStyle('Q')->applyFromArray($align_text);
        $sheet->getStyle('R')->applyFromArray($align_text);
        $sheet->getStyle('S')->applyFromArray($align_text);
        $sheet->getStyle('T')->applyFromArray($align_text);
        $sheet->getStyle('U')->applyFromArray($align_text);
        $sheet->getStyle('V')->applyFromArray($align_text);
        $sheet->getStyle('W')->applyFromArray($align_text);
        $sheet->getStyle('X')->applyFromArray($align_text);
        $sheet->getStyle('Y')->applyFromArray($align_text);
        $sheet->getStyle('Z')->applyFromArray($align_text);
        $sheet->getStyle('AA')->applyFromArray($align_text);
        $sheet->getStyle('AB')->applyFromArray($align_text);
        $sheet->getStyle('AC')->applyFromArray($align_text);
        $sheet->getStyle('AD')->applyFromArray($align_text);
        $sheet->getStyle('AE')->applyFromArray($align_text);
        $sheet->getStyle('AF')->applyFromArray($align_text);
        $sheet->getStyle('AG')->applyFromArray($align_text);
        $sheet->getStyle('AH')->applyFromArray($align_text);
        $sheet->getStyle('AI')->applyFromArray($align_text);
        $sheet->getStyle('AJ')->applyFromArray($align_text);
        $sheet->getStyle('AK')->applyFromArray($align_text);
        $sheet->getStyle('AL')->applyFromArray($align_text);
        $sheet->getStyle('AM')->applyFromArray($align_text);
        $sheet->getStyle('AN')->applyFromArray($align_text);
        $sheet->getStyle('AO')->applyFromArray($align_text);
        $sheet->getStyle('AP')->applyFromArray($align_text);
        $sheet->getStyle('AQ')->applyFromArray($align_text);
        $sheet->getStyle('AR')->applyFromArray($align_text);
        $sheet->getStyle('AS')->applyFromArray($align_text);
        $sheet->getStyle('AT')->applyFromArray($align_text);
        $sheet->getStyle('AU')->applyFromArray($align_text);
        $sheet->getStyle('AV')->applyFromArray($align_text);
        $sheet->getStyle('AW')->applyFromArray($align_text);
        $sheet->getStyle('AX')->applyFromArray($align_text);
        $sheet->getStyle('AY')->applyFromArray($align_text);

        $sheet->getStyle('A1')->applyFromArray($light_brown);
        $sheet->getStyle('B1')->applyFromArray($brown);

        $sheet->getStyle('C1')->applyFromArray($light_brown);
        $sheet->duplicateStyle($sheet->getStyle('C1'), 'C1:L1');

        $sheet->getStyle('M1')->applyFromArray($light_blue);

        $sheet->getStyle('N1')->applyFromArray($light_brown);

        $sheet->getStyle('O1')->applyFromArray($light_blue);
        $sheet->duplicateStyle($sheet->getStyle('O1'), 'O1:R1');

        $sheet->getStyle('S1')->applyFromArray($light_brown);

        $sheet->getStyle('T1')->applyFromArray($light_brown);
        $sheet->duplicateStyle($sheet->getStyle('T1'), 'T1:X1');

        $sheet->getStyle('Y1')->applyFromArray($light_blue);
    }

    protected function anlagenType($tehnic)
    {

        if ( $tehnic->type2 ) {

            return $tehnic->type2;
        }else {

            return $tehnic->Type;
        }
    }
}