<?php

namespace backend\controllers;

use Yii;
use common\models\Tehnical;
use common\models\CronXls;
use common\models\Images;
use common\models\search\TehinicalSearch;
use common\models\search\TehinicalGlobalBackendSearch;
use common\models\Aufzugswarter;
use common\models\AufzugswarterTehnicJoin;
use common\models\User;
use common\models\Wartungsfirma;
use common\models\Type;
use common\models\Type2;
use common\models\Antriebsart;
use common\models\Betriebskontrollen;
use common\models\Wartungsart;
use common\models\Anlagentyp;
use common\models\AnlagenStatus;
use common\models\Evaluierung;
use common\models\GoogleCordinate; # Add Anlagen to the map
use common\models\GeratMangel;
use common\models\Frist;
use common\models\TehnicalDocument;
use common\models\UserAnlagenCoworkerControl;
use common\models\CoworkerControll;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
//use mPDF;
use common\models\TehnicReview;
use common\models\Role;
use yii\web\UploadedFile;
use yii\web\Response;
use kartik\mpdf\Pdf;
use dosamigos\google\maps\services\DirectionsClient;
use dosamigos\google\maps\LatLng;
use dosamigos\google\maps\services\DirectionsWayPoint;
use dosamigos\google\maps\services\TravelMode;
use dosamigos\google\maps\overlays\PolylineOptions;
use dosamigos\google\maps\services\DirectionsRenderer;
use dosamigos\google\maps\services\DirectionsService;
use dosamigos\google\maps\overlays\InfoWindow;
use dosamigos\google\maps\overlays\Marker;
use dosamigos\google\maps\Map;
use dosamigos\google\maps\services\DirectionsRequest;
use dosamigos\google\maps\overlays\Polygon;
use dosamigos\google\maps\layers\BicyclingLayer;
use DateTime;
use DateTimeZone;
use yii\helpers\ArrayHelper;
use yii\data\Pagination;
use common\models\Prufgrundlage;
use common\models\Norm;
use common\models\Magel;
use common\models\MangelProperties;
use common\models\RestApiAuth;
    use \PHPExcel;
    use \PHPExcel_IOFactory;
    use \PHPExcel_Settings;
    use \PHPExcel_Style_Fill;
    use \PHPExcel_Writer_IWriter;
    use \PHPExcel_Worksheet;
    use \PHPExcel_Style_Alignment;
    use \PHPExcel_Style_Border;
    use \PHPExcel_Cell;
    use \PHPExcel_Cell_DataType;

define( 'ACCESS_TOKEN',  'c87be3215ff69092dbe7d5a9e10ecb9236254108-150-56c04f15ad' );
define( 'CLIENT_SECRET', 'c87be3215ff69092dbe7d5a9e10ecb9236254108-150-7957e2d2a1' );
define( 'CONTENT_TYPE',  'application/json' );
define( 'ACCEPTS',       'application/json' );
define( 'ENDPOINT',      'https://dev.anlagendoku.com/admin/' );


class ImportFromExcelController extends Controller
{



    public function removeExcelRowAfterAddedToDB($worksheet, $excelObj, $filename, $row) {

        if ($worksheet != NULL) {

            if ($worksheet->removeRow($row, 1)) {
                $objWriter = PHPExcel_IOFactory::createWriter($excelObj, 'Excel2007');
                $objWriter->save($filename);
            }
            sleep(1);
        }
        return true;
    }


   
    public function actionIndex()
    {

        $objects = array();
        $data = $_SERVER;



        if( $data && $data["HTTP_ACCESS_TOKEN"] && $data["HTTP_CLIENT_SECRET"] ) {

            $token = $data["HTTP_ACCESS_TOKEN"];
            $secret = $data["HTTP_CLIENT_SECRET"];

            if($token  == 'c87be3215ff69092dbe7d5a9eqweqweqwe10ecb9236254108-150-56c04f15ad' && 
                $secret == 'c87be3215ff69092dbe7d5a9ertrterte10ecb9236254108-150-7957e2d2a1') {

                $this->actionImport();
            }
        }   
        return false;     
    }
   
    public function actionImport()
    {
       // \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
		$cron = CronXls::find()->one();
		$inputFile = $cron->url;
        $data = $_SERVER;
        $date_now = date('Y-m-d H:i');
        $cron_time_plus_two_minutes = date('Y-m-d H:i',strtotime('+2 minutes',strtotime($cron->date)));
        $date_now_plus_five_minutes = date('Y-m-d H:i',strtotime('+10 minutes',strtotime(date('Y-m-d H:i'))));

        if($cron_time_plus_two_minutes < $date_now) {

            try {
                $inputFileType = \PHPExcel_IOFactory::identify($inputFile);
                $objectReader = \PHPExcel_IOFactory::createReader($inputFileType);
                $excelObj = $objectReader->load($inputFile);
                $objWorksheet = $excelObj->getActiveSheet();
                $filename = $cron->url;


            }catch(Exception $e) {

            }

            $sheets = [0, 1, 2, 3];
            $last_sheet = end( $sheets );
            $rowData = [];
            $count = 1;

            foreach ($sheets as $key1 => $sheet) {
                sleep(2);
                $worksheet = $excelObj->getSheet($sheet);
                 $sheetData = $worksheet->toArray(null,true,true,true);

                $lastRow = $worksheet->getHighestRow();
                $lastColumn = $worksheet->getHighestColumn();
                $highestColumnIndex = PHPExcel_Cell::columnIndexFromString($lastColumn);
                $rowDatas = $worksheet->toArray(null, true,true,true);

                foreach ($rowDatas as $key => $rowData) {

                    if ( $key == 0 || $key == 1 || $key == 2 ) {
                        continue;
                    }

                    if(/*$count == 50*/ $date_now_plus_five_minutes == date('Y-m-d H:i')) {
                        return;
                    }

                    if(gettype($rowData["D"]) == 'string') {

                        $AnlagenIdWithAT = $rowData["D"];
                        $AnlagenId = filter_var($AnlagenIdWithAT, FILTER_SANITIZE_NUMBER_INT);
                        $anlagen_exist = Tehnical::findOne($AnlagenId);
                        $Email = $rowData["B"];
                        $user = $this->check_or_create_user($Email, $rowData);

                        if ( $anlagen_exist ) {
                            $this->import_new_or_update_database_from_xls_file( $anlagen_exist, $user, $rowData, $sheet );
                        } else {
                            $anlagen = new Tehnical();
                            $anlagen->id = $AnlagenId;
                            $anlagen->ErstelltAm = date("Y.m.d");
                            $this->import_new_or_update_database_from_xls_file( $anlagen, $user, $rowData, $sheet );
                        }

                        $this->removeExcelRowAfterAddedToDB($worksheet, $excelObj, $filename, 3);
                        $this->updateDateOnCronXls();
                        $count += 1;         
                    }
                }
            }
                
            $cron->date = $date_now;
            $cron->save();
        };
        return true;
    }

    protected function updateDateOnCronXls() {
        $date = date('Y-m-d H:i');

        $model = CronXls::findOne(1);
        $model->date = $date;
        $model->save();
    }


    protected function import_new_or_update_database_from_xls_file( $anlagen_exist, $user, $rowData, $sheet )
    {

        if ( $sheet == 0 ) {

            $this->import_new_or_update_database_from_xls_fileAufzug( $anlagen_exist, $user, $rowData );
        }else if ( $sheet == 1 ) {

            $this->import_new_or_update_database_from_xls_fileKFZ( $anlagen_exist, $user, $rowData );
        }else if ( $sheet == 2 ) {
            
            $this->import_new_or_update_database_from_xls_fileArbeitsmittel( $anlagen_exist, $user, $rowData );
        }else if ( $sheet == 3 )  {

            $this->import_new_or_update_database_from_xls_fileSpiel( $anlagen_exist, $user, $rowData );
        }
    }

   protected function import_new_or_update_database_from_xls_fileAufzug( $anlagen, $user, $rowData )
    {

        $firma_id = $this->ensure_wartungs_firma( $rowData, "U" );
        $type_name = $this->ensure_type_excel( $rowData, "L" );
        $antriebsart_name = $this->ensure_antriebsart_excel( $rowData, "N" );
        $betriebskontrollen_name = $this->ensure_betriebskontrollen_excel( $rowData );
        $wartungsart_name = $this->ensure_wartungsart_excel( $rowData );
        $anlagentyp_name = $this->ensure_anlagentyp_excel( $rowData );
        $status_name = $this->ensure_anlagen_status_excel( $rowData );
        $evaluierung_name = $this->ensure_evaluierung_excel( $rowData );
        $evaluierungFristen = $this->ensure_evaluierungFristen_excel( $rowData ); 
        $worker = NULL;

        if( $rowData["Z"] ) {
            $worker = User::find()->where([ 'email' => $rowData["Z"]])->one();
        }
        
        $anlagen->user_id = $user->id;
        $anlagen->FabriksNr = (string)$rowData["E"];
        $anlagen->AdressePLZ = (string)$rowData["F"];
        $anlagen->AdresseOrt = (string)$rowData["G"];
        $anlagen->AdresseStreat = (string)$rowData["H"];
        $anlagen->Zusatz = (string)$rowData["I"];
        $anlagen->Hersteller = (string)$rowData["J"];
        $anlagen->Baujahr = (string)$rowData["K"];
        $anlagen->Type = $type_name;
        $anlagen->Anlagentyp = $rowData["M"];
        $anlagen->Antriebsart = $antriebsart_name;
        $anlagen->Haltestellen = (string)$rowData["O"];
        $anlagen->Ladestellen = (string)$rowData["P"];
        $anlagen->Nennlast = (int)$rowData["Q"];
        $anlagen->Notruftel = $rowData["R"];
        $anlagen->Schachtart = $rowData["S"];
        $anlagen->evaluierungName = $evaluierung_name;
        $anlagen->fabric_id = $firma_id;
        $anlagen->Wartungsart = $wartungsart_name;
        $anlagen->Betriebskontrollen = $betriebskontrollen_name;
        $anlagen->Notizen = $rowData["Y"];
        $anlagen->worker_email = $rowData["Z"];
        $anlagen->LetzteDate = $rowData["AA"];
        $anlagen->PreisWP = $rowData["AB"];
        $anlagen->ObjektNr = $rowData["AC"];
        $anlagen->UIDNUMMER = $rowData["AD"];
        $anlagen->Fakturenadresse = $rowData["AE"];
        $anlagen->Hausverwalter = $rowData["AF"];
        $anlagen->HausverwalterEmail = $rowData["AG"];
        $anlagen->KontaktVerwalter = $rowData["AH"];
        $anlagen->status = $rowData["AI"];
        $anlagen->lat = $rowData["AJ"];
        $anlagen->lng = $rowData["AK"];
        $anlagen->Personen = (int)$rowData["AL"];
        $anlagen->Nenngeschwindigkeit = (string)$rowData["AM"];
        $anlagen->Hubhohe = (string)$rowData["AN"];
        $anlagen->Gesetzt = (string)$rowData["AO"];
        $anlagen->Profintervall = (int)$rowData["AP"];
        $anlagen->evaluierungFristen = $evaluierungFristen;
        $anlagen->DatumderAbnahmeprufung = (string)$rowData["AR"];
        $anlagen->AnlagenNrKunde =(string)$rowData["AS"];
        $anlagen->KundenNr =(string)$rowData["AT"];
        $anlagen->Kunden_Rechnungszusatz =(string)$rowData["AU"];
        $anlagen->Kunden_Straße =(string)$rowData["AV"];
        $anlagen->Kunden_PLZ =(string)$rowData["AW"];
        $anlagen->Kunden_Ort =(string)$rowData["AX"];
        $anlagen->Kunden_Referenzzeile =(string)$rowData["AY"];
        $anlagen->Kunden_Rechnungsemail =(string)$rowData["AZ"];
        $anlagen->workerID = $worker && $worker->id ? $worker->id : null;
        $anlagen->save();

        $anlagen_id = $anlagen->id;
        if( $worker && isset($worker->id) ) {

            $coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen->id])->one();

            if( isset($coworker_anlagen_control) ) {

                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->save();
            }else {
                $coworker_anlagen_control = new UserAnlagenCoworkerControl();
                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->anlagen_id = $anlagen_id;
                $coworker_anlagen_control->save();
            }
                
        }else {
            $old_coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen_id])->one();
            if( $old_coworker_anlagen_control ) {
                $old_coworker_anlagen_control->delete();
            }
        }

        $this->ensure_aufzugswarters_excel( $rowData, $anlagen );
    }

    protected function import_new_or_update_database_from_xls_fileKFZ( $anlagen, $user, $rowData )
    {

        $firma_id = $this->ensure_wartungs_firma( $rowData, "R" );
        $type_name = $this->ensure_type_excel( $rowData, "L" );
        $prufgrundlage = $this->ensure_prufgrundlage_excel( $rowData, "M" );
        $antriebsart_name = $this->ensure_antriebsart_excel( $rowData, "N" );
        $worker = NULL;

        if( $rowData["T"]) {
            $worker = User::find()->where(['email' => $rowData["T"]])->one();
        }

        $anlagen->user_id = $user->id;
        $anlagen->FabriksNr = (string)$rowData["E"];
        $anlagen->AdressePLZ = (string)$rowData["F"];
        $anlagen->AdresseOrt = (string)$rowData["G"];
        $anlagen->AdresseStreat = (string)$rowData["H"];
        $anlagen->Zusatz = (string)$rowData["I"];
        $anlagen->Hersteller = (string)$rowData["J"];
        $anlagen->Baujahr = (string)$rowData["K"];
        $anlagen->Type = $type_name;
        $anlagen->Prufgrundlage = $prufgrundlage;
        $anlagen->Antriebsart = $antriebsart_name;
        $anlagen->Parkeranagen = $rowData["O"];
        $anlagen->AnzahltStellplatze = (string)$rowData["P"];
        $anlagen->Nennlast = (int)$rowData["Q"];
        $anlagen->fabric_id = $firma_id;
        $anlagen->Notizen = $rowData["S"];
        $anlagen->worker_email = $rowData["T"];
        $anlagen->LetzteDate = $rowData["U"];
        $anlagen->Profintervall = (string)$rowData["V"];
        $anlagen->PreisWP = $rowData["W"];
        $anlagen->ObjektNr = $rowData["X"];
        $anlagen->UIDNUMMER = $rowData["Y"];
        $anlagen->Fakturenadresse = $rowData["Z"];
        $anlagen->Hausverwalter = $rowData["AA"];
        $anlagen->HausverwalterEmail = $rowData["AB"];
        $anlagen->KontaktVerwalter = $rowData["AC"];
        $anlagen->status = $rowData["AD"];
        $anlagen->lat = $rowData["AE"];
        $anlagen->lng = $rowData["AF"];
        $anlagen->AnlagenNrKunde =(string)$rowData["AG"];
        $anlagen->KundenNr =(string)$rowData["AH"];
        $anlagen->Kunden_Rechnungszusatz =(string)$rowData["AI"];
        $anlagen->Kunden_Straße =(string)$rowData["AJ"];
        $anlagen->Kunden_PLZ =(string)$rowData["AK"];
        $anlagen->Kunden_Ort =(string)$rowData["AL"];
        $anlagen->Kunden_Referenzzeile =(string)$rowData["AM"];
        $anlagen->Kunden_Rechnungsemail =(string)$rowData["AN"];
        $anlagen->workerID = $worker && $worker->id ? $worker->id : null;
        $anlagen->save();
        $anlagen_id = $anlagen->id;

        if( $worker && isset($worker->id) ) {

            $coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen->id])->one();

            if( isset($coworker_anlagen_control) ) {

                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->save();
            }else {
                $coworker_anlagen_control = new UserAnlagenCoworkerControl();
                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->anlagen_id = $anlagen_id;
                $coworker_anlagen_control->save();
            }
                
        }else {
            $old_coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen_id])->one();
            if( $old_coworker_anlagen_control ) {
                $old_coworker_anlagen_control->delete();
            }
        } 
    }

    protected function import_new_or_update_database_from_xls_fileArbeitsmittel( $anlagen, $user, $rowData )
    {

        $firma_id = $this->ensure_wartungs_firma( $rowData, 'Q' );
        $type_name = $this->ensure_type_excel( $rowData, 'L' );
        $type2_name = $this->ensure_type2_excel( $rowData, 'M' );
        $prufgrundlage = $this->ensure_prufgrundlage_excel( $rowData, 'N' );
        $antriebsart_name = $this->ensure_antriebsart_excel( $rowData, 'O' );

        $worker = NULL;

        if( $rowData['S'] ) {
            $worker = User::find()->where(['email' => $rowData['S']])->one();
        }

        $anlagen->user_id = $user->id;
        $anlagen->FabriksNr = (string)$rowData['E'];
        $anlagen->AdressePLZ = (string)$rowData['F'];
        $anlagen->AdresseOrt = (string)$rowData['G'];
        $anlagen->AdresseStreat = (string)$rowData['H'];
        $anlagen->Zusatz = (string)$rowData['I'];
        $anlagen->Hersteller = (string)$rowData['J'];
        $anlagen->Baujahr = (string)$rowData['K'];
        $anlagen->Type = $type_name;
        $anlagen->type2 = $type2_name;
        $anlagen->Prufgrundlage = $prufgrundlage;
        $anlagen->Antriebsart = $antriebsart_name;
        $anlagen->Durchfahrtslichte_in_m = $rowData['P'];
        $anlagen->fabric_id = $firma_id;
        $anlagen->Notizen = $rowData['R'];
        $anlagen->worker_email = $rowData['S'];
        $anlagen->LetzteDate = $rowData['T'];
        $anlagen->Profintervall = (string)$rowData['U'];
        $anlagen->PreisWP = $rowData['V'];
        $anlagen->ObjektNr = $rowData['W'];
        $anlagen->UIDNUMMER = $rowData['X'];
        $anlagen->Fakturenadresse = $rowData['Y'];
        $anlagen->Hausverwalter = $rowData['Z'];
        $anlagen->HausverwalterEmail = $rowData['AA'];
        $anlagen->KontaktVerwalter = $rowData['AB'];
        $anlagen->status = $rowData['AC'];
        $anlagen->lat = $rowData['AD'];
        $anlagen->lng = $rowData['AE'];
        $anlagen->AnlagenNrKunde =(string)$rowData['AF'];
        $anlagen->KundenNr =(string)$rowData['AG'];
        $anlagen->Kunden_Rechnungszusatz =(string)$rowData['AH'];
        $anlagen->Kunden_Straße =(string)$rowData['AI'];
        $anlagen->Kunden_PLZ =(string)$rowData['AJ'];
        $anlagen->Kunden_Ort =(string)$rowData['AK'];
        $anlagen->Kunden_Referenzzeile =(string)$rowData['AL'];
        $anlagen->Kunden_Rechnungsemail =(string)$rowData['AM'];
        $anlagen->workerID = $worker && $worker->id ? $worker->id : null;
        $anlagen->save();
        $anlagen_id = $anlagen->id;


        if( $worker && isset($worker->id) ) {

            $coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen->id])->one();

            if( isset($coworker_anlagen_control) ) {

                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->save();
            }else {
                $coworker_anlagen_control = new UserAnlagenCoworkerControl();
                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->anlagen_id = $anlagen_id;
                $coworker_anlagen_control->save();
            }
                
        }else {
            $old_coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen_id])->one();
            if( $old_coworker_anlagen_control ) {
                $old_coworker_anlagen_control->delete();
            }
        } 
    }

    protected function import_new_or_update_database_from_xls_fileSpiel( $anlagen, $user, $rowData )
    {
        $norm = $this->ensure_norm_excel( $rowData, 'M' );
        $prufgrundlage = $this->ensure_prufgrundlage_excel( $rowData, 'N' );
        $firma_id = $this->ensure_wartungs_firma( $rowData, 'O' ); 

        $worker = NULL;

        if( $rowData['Q'] ) {
            $worker = User::find()->where(['email' => $rowData['Q']])->one();
        }

        $anlagen->user_id = $user->id;
        $anlagen->FabriksNr = (string)$rowData['E'];
        $anlagen->AdressePLZ = (string)$rowData['F'];
        $anlagen->AdresseOrt = (string)$rowData['G'];
        $anlagen->AdresseStreat = (string)$rowData['H'];
        $anlagen->Zusatz = (string)$rowData['I'];
        $anlagen->Hersteller = (string)$rowData['J'];
        $anlagen->Baujahr = (string)$rowData['K'];
        $anlagen->Inspetkionsobjekt = $rowData['L'];
        $anlagen->Norm = $norm;
        $anlagen->Prufgrundlage = $prufgrundlage;
        $anlagen->fabric_id = $firma_id;
        $anlagen->Notizen = $rowData['P'];
        $anlagen->worker_email = $rowData['Q'];
        $anlagen->LetzteDate = $rowData['R'];
        $anlagen->Profintervall = (string)$rowData['S'];
        $anlagen->PreisWP = $rowData['T'];
        $anlagen->ObjektNr = $rowData['U'];
        $anlagen->UIDNUMMER = $rowData['V'];
        $anlagen->Fakturenadresse = $rowData['W'];
        $anlagen->Hausverwalter = $rowData['X'];
        $anlagen->HausverwalterEmail = $rowData['Y'];
        $anlagen->KontaktVerwalter = $rowData['Z'];
        $anlagen->status = $rowData['AA'];
        $anlagen->lat = $rowData['AB'];
        $anlagen->lng = $rowData['AC'];
        $anlagen->AnlagenNrKunde =(string)$rowData['AD'];
        $anlagen->KundenNr =(string)$rowData['AE'];
        $anlagen->Kunden_Rechnungszusatz =(string)$rowData['AF'];
        $anlagen->Kunden_Straße =(string)$rowData['AG'];
        $anlagen->Kunden_PLZ =(string)$rowData['AH'];
        $anlagen->Kunden_Ort =(string)$rowData['AI'];
        $anlagen->Kunden_Referenzzeile =(string)$rowData['AJ'];
        $anlagen->Kunden_Rechnungsemail =(string)$rowData['AK'];    
        $anlagen->Type = "Spielplatzgeräte";
        $anlagen->workerID = $worker && $worker->id ? $worker->id : null;
        $anlagen->save();
        $anlagen_id = $anlagen->id;


        if( $worker && isset($worker->id) ) {

            $coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen->id])->one();

            if( isset($coworker_anlagen_control) ) {

                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->save();
            }else {
                $coworker_anlagen_control = new UserAnlagenCoworkerControl();
                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->anlagen_id = $anlagen_id;
                $coworker_anlagen_control->save();
            }
                
        }else {
            $old_coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen_id])->one();
            if( $old_coworker_anlagen_control ) {
                $old_coworker_anlagen_control->delete();
            }
        } 
    }

	protected function ensure_wartungs_firma( $rowData, $row_num )
    {

        $firma_name = (string)$rowData[$row_num];
        $firma  = Wartungsfirma::find()->where(['name'=> $firma_name])->one();

        if ( $firma ) {

            return $firma->id;

        }elseif ( $firma_name ) {

            $firma = new Wartungsfirma();
            $firma->name = (string)$rowData[$row_num];
            $firma->save();
            return $firma->id;
        }else {
            return false;
        }
    }


    protected function ensure_type_excel( $rowData, $row_num )
    {
        $type_name = (string)$rowData[$row_num];
        $type  = Type::find()->where(['name'=> $type_name])->one();

        if ( $type ) {

            return $type_name;
        }elseif($type_name != null || $type_name != "") {

            $type = new Type();
            $type->name = $type_name;
            $type->save();
            return $type_name;
        }else {
            return null;
        }
    }


    protected function ensure_antriebsart_excel( $rowData, $row_num )
    {
        $antriebsart_name = $rowData[$row_num];
        $antriebsart  = Antriebsart::find()->where(['name'=> $antriebsart_name])->one();

        if ( $antriebsart ) {

            return $antriebsart_name;
        }elseif($antriebsart_name != null || $antriebsart_name != "") {

            $antriebsart = new Antriebsart();
            $antriebsart->name = $antriebsart_name;
            $antriebsart->save();
            return $antriebsart_name;
        }else {
            return null;
        }
    }

    protected function ensure_betriebskontrollen_excel( $rowData )
    {
        $betriebskontrollen_name = $rowData["W"];
        $betriebskontrollen  = Betriebskontrollen::find()->where(['name'=> $betriebskontrollen_name])->one();

        if ( $betriebskontrollen ) {
            return $betriebskontrollen_name;
        }elseif( $betriebskontrollen_name != null || $betriebskontrollen_name != "" ) {
            $betriebskontrollen = new Betriebskontrollen();
            $betriebskontrollen->name = $betriebskontrollen_name;
            $betriebskontrollen->save();
            return $betriebskontrollen_name;
        }else {
            return null;
        }    
    }

    protected function ensure_wartungsart_excel( $rowData )
    {
        $wartungsart_name = $rowData["V"];
        $wartungsart  = Wartungsart::find()->where(['name'=> $wartungsart_name])->one();

        if ( $wartungsart ) {
            return $wartungsart_name;
        }elseif( $wartungsart_name != null || $wartungsart_name != "" ) {
            $wartungsart = new Wartungsart();
            $wartungsart->name = $wartungsart_name;
            $wartungsart->save();
            return $wartungsart_name;
        }else {
            return null;
        }       
    }

    protected function ensure_anlagentyp_excel( $rowData )
    {
        $anlagentyp_name = $rowData["M"];
        $anlagentyp  = Anlagentyp::find()->where(['name'=> $anlagentyp_name])->one();

        if ( $anlagentyp ) {
            return $anlagentyp_name;
        }elseif( $anlagentyp_name != null || $anlagentyp_name != "" ) {
            $anlagentyp = new Anlagentyp();
            $anlagentyp->name = $anlagentyp_name;
            $anlagentyp->save();
            return $anlagentyp_name;
        }else {
            return null;
        }         
    }

    protected function ensure_anlagen_status_excel( $rowData )
    {
        $status_name = $rowData["AI"];
        $status  = AnlagenStatus::find()->where(['name'=> $status_name])->one();

        if ( $status ) {
            return $status_name;
        }elseif( $status_name != null || $status_name != "" ) {
            $status = new AnlagenStatus();
            $status->name = $status_name;
            $status->save();
            return $status_name;
        }else {
            return null;
        }   
    }

    protected function ensure_evaluierung_excel( $rowData )
    {
        $evaul_name = $rowData["T"];
        $evaluierung  = Evaluierung::find()->where(['name'=> $evaul_name])->one();

        if ( $evaluierung ) {
            return $evaul_name;
        }elseif( $evaul_name != null || $evaul_name != "" ) {
            $evaluierung = new Evaluierung();
            $evaluierung->name = $evaul_name;
            $evaluierung->save();
            return $evaul_name;
        }else {
            return null;
        }   
    }

    protected function ensure_evaluierungFristen_excel( $rowData )
    {
        $date = $rowData["AR"];
        if ( $date != "" || $date != null) {

            $date = str_replace(".","-", $date);
            $date = DateTime::createFromFormat('d-m-Y', $date)->format('Y-m-d');

            return  $date;  
            }else {
                return null;
        }
    }

    protected function ensure_aufzugswarters_excel( $rowData, $anlagen ) 
    {
        $aufzugswarters_string = $rowData["X"];
        $aufzugswarters_array = explode(', ', $aufzugswarters_string);
        AufzugswarterTehnicJoin::deleteAll('tehnic_id = :tehnic_id', [':tehnic_id' => (int)$anlagen->id ]);

        foreach ($aufzugswarters_array as $key => $aufzugswarter) {
            if ( $aufzugswarter != "" || $aufzugswarter != null ) {

                $aufzugswarter_object  = Aufzugswarter::find()->where(['name'=> $aufzugswarter])->one();

                if ( $aufzugswarter_object && $aufzugswarter_object->id ) {
                   $this->create_aufzugswarter_tehnic_join_from_excel($aufzugswarter_object, $anlagen);   
                }else {

                    $aufzugswarter_new = new Aufzugswarter();
                    $aufzugswarter_new->name = $aufzugswarter;
                    if ( $aufzugswarter_new->save() ) {
                    
                        $this->create_aufzugswarter_tehnic_join_from_excel($aufzugswarter_new, $anlagen);
                    }               
                }
            }
        }
    }

    protected function create_aufzugswarter_tehnic_join_from_excel($aufzugswarter_new, $anlagen)
    {   
        $model_lift = new AufzugswarterTehnicJoin();
        $model_lift->tehnic_id = (int)$anlagen->id;
        $model_lift->aufzugswarter_id = (int)$aufzugswarter_new->id;
        $model_lift->save();        
    }

    protected function ensure_prufgrundlage_excel( $rowData, $row_num )
    {
        $prufgrundlage_name = (string)$rowData[$row_num];
        $prufgrundlage  = Prufgrundlage::find()->where(['name'=> $prufgrundlage_name])->one();

        if ( $prufgrundlage ) {

            return $prufgrundlage_name;
        }elseif($prufgrundlage_name != null || $prufgrundlage_name != "") {

            $prufgrundlage = new Prufgrundlage();
            $prufgrundlage->name = $prufgrundlage_name;
            $prufgrundlage->save();
            return $prufgrundlage_name;
        }else {
            return null;
        }
    }

    protected function ensure_type2_excel( $rowData, $row_num )
    {
        $type_name = (string)$rowData[$row_num];
        $type  = Type2::find()->where(['name'=> $type_name])->one();

        if ( $type ) {

            return $type_name;
        }elseif($type_name != null || $type_name != "") {

            $type = new Type2();
            $type->name = $type_name;
            $type->save();
            return $type_name;
        }else {
            return null;
        }
    }

    protected function ensure_norm_excel( $rowData, $row_num )
    {
        $norm_name = (string)$rowData[$row_num];
        $norm  = Norm::find()->where(['name'=> $norm_name])->one();

        if ( $norm ) {

            return $norm_name;
        }elseif($norm_name != null || $norm_name != "") {

            $norm = new Norm();
            $norm->name = $norm_name;
            $norm->save();
            return $norm_name;
        }else {
            return null;
        }
    }

    protected function check_or_create_user($Email, $rowData)
    {
        $user = User::find()->where(['email'=> $Email])->one();

        if ( !$user  ) {

            $user = new User();

            $user_password = bin2hex(openssl_random_pseudo_bytes(10));
            $user_email =  $rowData["B"];
            $send_mail = $rowData["C"];

            $user->username = $user_email;
            $user->email = $user_email;
            $user->role_id = 2;
            $user->send_mail = $send_mail;
            $user->setPassword($user_password);
            $user->client_password = $user_password;
            $user->generateAuthKey();
            $user->Betreiber = $rowData["A"];
            $user->save();


         #   if ( $send_mail === true || $send_mail === "true" ) {

         #       $this->sendMailToUserWithoutTinmceDescription($user, $user_password);
         #       sleep(1);
         #   }

            return $user;
        }else {

            return $user;
        }
    }
}