<?php

namespace backend\controllers;

	use Yii;
    use Closure;
    use yii\i18n\Formatter;
    use yii\base\InvalidConfigException;
    use yii\helpers\Url;
    use yii\helpers\Html;
    use yii\helpers\Json;
    use yii\helpers\ArrayHelper;
    use yii\widgets\BaseListView;
    use yii\base\Model;
    use common\models\User;
    use \PHPExcel;
    use \PHPExcel_IOFactory;
    use \PHPExcel_Settings;
    use \PHPExcel_Style_Fill;
    use \PHPExcel_Writer_IWriter;
    use \PHPExcel_Worksheet;
    use \PHPExcel_Style_Alignment;
    use \PHPExcel_Style_Border;
    use common\models\Tehnical;
    use common\models\Wartungsfirma;
	use DateTime;
	use DateTimeZone;
/**
 * AdminController implements the CRUD actions for User model.
 */
class ExportController extends ExportBaseController
{


	public function actionDownload()
	{
		
		$excel_props = array('creator' => 'Anlagendoku Application'
        , 'title' => 'Anlagendoku'
        , 'subject' => 'http://www.anlagendoku.com export data'
        , 'desc' => 'Freie-ingenieure data export excel'
        , 'keywords' => 'WWSP Tool Generated Excel, Author: Belmir Hamidovic'
        , 'category' => 'Freie-ingenieure data export excel');

		$user_id = $_GET['user_id'];

		if ( $user_id && $user_id != "null") {

			$user = User::findOne($user_id);
		}else {

			$user = null;
		}

		if ( $user_id && $user ) {
			
	#		$tehnicals = $user->getTehnicals()->all();
			$tehnicals = $user->getTehnicals()->where(['not', ['Type' => 'Spielplatzgeräte']])->andWhere(['not', ['Type' => 'KFZ Parkeranlage']])->andWhere(['not', ['Type' => 'Arbeitsmittel']])->all();
			 $tehnicals_kfz = $user->getTehnicals()->where(['Type' => 'KFZ Parkeranlage'])->all();
			 $tehnicals_arbeitsmittel = $user->getTehnicals()->where(['Type' => 'Arbeitsmittel'])->all();
			 $tehnicals_spielplatzgerste = $user->getTehnicals()->where(['Type' => 'Spielplatzgeräte'])->all();

		}else {
			
			#$tehnicals = Tehnical::find()->all();
			$tehnicals = Tehnical::find()->where(['not', ['Type' => 'Spielplatzgeräte']])->andWhere(['not', ['Type' => 'KFZ Parkeranlage']])->andWhere(['not', ['Type' => 'Arbeitsmittel']])->all();
			$tehnicals_kfz = Tehnical::find()->where(['Type' => 'KFZ Parkeranlage'])->all();
			$tehnicals_arbeitsmittel = Tehnical::find()->where(['Type' => 'Arbeitsmittel'])->all();
			$tehnicals_spielplatzgerste = Tehnical::find()->where(['Type' => 'Spielplatzgeräte'])->all();
		}

        $lastRow = count($tehnicals);

		$objPHPExcel = new PHPExcel();
  		$objProps = $objPHPExcel->getProperties();
        $objProps->setCreator($excel_props['creator']);
        $objProps->setLastModifiedBy($excel_props['creator']);
        $objProps->setTitle($excel_props['title']);
        $objProps->setSubject($excel_props['subject']);
        $objProps->setDescription($excel_props['desc']);
        $objProps->setKeywords($excel_props['keywords']);
        $objProps->setCategory($excel_props['category']);

        if ( count($tehnicals) > 0 ) {

        	$sheet_index = 0;
			$sheet_title = "Aufzug";       	
        	$this->ensureSheetWithData($tehnicals, $sheet_index, $sheet_title, $objPHPExcel );
        }

        if ( count($tehnicals_kfz) > 0 ) {

        	$sheet_index = 1;
			$sheet_title = "KFZ";       	
        	$this->ensureSheetWithData($tehnicals_kfz, $sheet_index, $sheet_title, $objPHPExcel );
        }

        if ( count($tehnicals_arbeitsmittel) > 0 ) {

        	$sheet_index = 2;
			$sheet_title = "Arbeitsmittel";       	
        	$this->ensureSheetWithData($tehnicals_arbeitsmittel, $sheet_index, $sheet_title, $objPHPExcel );
        }

        if ( count($tehnicals_spielplatzgerste) > 0 ) {

        	$sheet_index = 3;
			$sheet_title = "Spiel";       	
        	$this->ensureSheetWithData($tehnicals_spielplatzgerste, $sheet_index, $sheet_title, $objPHPExcel );
        }

		$filename=mt_rand(1,100000).'.xlsx'; //just some random filename
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Cache-Control: max-age=0');
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007'); 
		$objWriter->save('php://output');
	}

	protected function ensureSheetWithData( $tehnicals, $sheet_index, $sheet_title, $objPHPExcel )
	{

		$objPHPExcel->createSheet();
		$objPHPExcel->setActiveSheetIndex( $sheet_index );

		$sheet = $objPHPExcel->getActiveSheet();
		$sheet->setTitle( $sheet_title );

		//////////////////////////////////////////////// DATA EXPORT
		$this->dataInitialize($sheet, $tehnicals, $sheet_title);
		$this->headerInitialize($sheet, $tehnicals, $sheet_title);
		/////////////////////////////////////////////////////
		$this->ensureSheetStyle($sheet, $tehnicals, $sheet_title);
		$this->ensureSheetSize($sheet, $sheet_title);
	}

	protected function dataInitialize( $sheet, $tehnicals, $sheet_title )
	{

		if ( $sheet_title == "Aufzug" ) {

			$this->dataInitializeAufzug($sheet, $tehnicals);
		}else if ( $sheet_title == "KFZ" ) {

			$this->dataInitializeKFZ($sheet, $tehnicals);
		}else if ( $sheet_title == "Arbeitsmittel" ) {

			$this->dataInitializeArbeitsmittel($sheet, $tehnicals);
		}else {

			$this->dataInitializeSpiel($sheet, $tehnicals);
		}
	}

	protected function headerInitialize( $sheet, $tehnicals, $sheet_title )
	{

		if ( $sheet_title == "Aufzug" ) {

			$this->headerInitializeAufzug($sheet);
		}else if ( $sheet_title == "KFZ" ) {

			$this->headerInitializeKFZ($sheet);
		}else if ( $sheet_title == "Arbeitsmittel" ) {

			$this->headerInitializeArbeitsmittel($sheet);
		}else {

			$this->headerInitializeSpiel($sheet);
		}
	}

	protected function ensureSheetStyle( $sheet, $tehnicals, $sheet_title )
	{

		$styleHeaderCustomer = $this->styleHeaderCustomerStylesheetInitializeA1E1();
		$styleHeaderCustomer2 = $this->styleHeaderCustomerStylesheetInitializeA2E2();
		$styleHeaderCustomer_F_T = $this->styleHeaderCustomerStylesheetInitializeF1T1();
		$styleHeaderCustomer_F_T2 = $this->styleHeaderCustomerStylesheetInitializeF2T2();
		$invoice_color = $this->styleHeaderInvoiceColor();
		$styleHeaderFirma = $this->styleHeaderFirma();
		$styleHeaderFirma2 = $this->styleHeaderFirma2();
		$styleHeaderPreisWP = $this->styleHeaderPreisWP();
		$align_text = $this->align_text_stylesheetInitialize();
		$styleHeaderDate = $this->styleHeaderDate();


		if ( $sheet_title == "Aufzug" ) {

			$this->headerStyleAufzug( $sheet, $align_text, $styleHeaderCustomer, $styleHeaderCustomer_F_T, $styleHeaderFirma, $styleHeaderPreisWP, $styleHeaderCustomer2, $styleHeaderCustomer_F_T2, $styleHeaderFirma2, $styleHeaderDate, $invoice_color );
		}else if ( $sheet_title == "KFZ" ) {

			$this->headerStyleKFZ( $sheet, $align_text, $styleHeaderCustomer, $styleHeaderCustomer_F_T, $styleHeaderFirma, $styleHeaderPreisWP, $styleHeaderCustomer2, $styleHeaderCustomer_F_T2, $styleHeaderFirma2, $styleHeaderDate, $invoice_color );
		}else if ( $sheet_title == "Arbeitsmittel" ) {

			$this->headerStyleArbeitsmittel( $sheet, $align_text, $styleHeaderCustomer, $styleHeaderCustomer_F_T, $styleHeaderFirma, $styleHeaderPreisWP, $styleHeaderCustomer2, $styleHeaderCustomer_F_T2, $styleHeaderFirma2, $styleHeaderDate, $invoice_color );
		}else {

			$this->headerStyleSpiel( $sheet, $align_text, $styleHeaderCustomer, $styleHeaderCustomer_F_T, $styleHeaderFirma, $styleHeaderPreisWP, $styleHeaderCustomer2, $styleHeaderCustomer_F_T2, $styleHeaderFirma2, $styleHeaderDate, $invoice_color );
		}
	}
}