<?php

namespace backend\controllers;

	use Yii;
    use Closure;
    use yii\i18n\Formatter;
    use yii\base\InvalidConfigException;
    use yii\helpers\Url;
    use yii\helpers\Html;
    use yii\helpers\Json;
    use yii\helpers\ArrayHelper;
    use yii\widgets\BaseListView;
    use yii\base\Model;
    use common\models\User;
    use \PHPExcel;
    use \PHPExcel_IOFactory;
    use \PHPExcel_Settings;
    use \PHPExcel_Style_Fill;
    use \PHPExcel_Writer_IWriter;
    use \PHPExcel_Worksheet;
    use \PHPExcel_Style_Alignment;
    use \PHPExcel_Style_Border;
    use \PHPExcel_Shared_String;
    use common\models\Tehnical;
    use common\models\Wartungsfirma;
	use DateTime;
	use DateTimeZone;
/**
 * AdminController implements the CRUD actions for User model.
 */
class ExcelApiController extends BaseController
{
    public function actionIndex()
    {



        return $this->render('index', [

        ]);
    }

	public function actionDownload()
	{
		$user_id = 51; /*$_GET['user_id'];*/
		$user = User::findOne($user_id);
		$tehnical = $user->getTehnicals()->all();

		// Create new PHPExcel object
		$objPHPExcel = new PHPExcel();
		$sheet = $objPHPExcel->getActiveSheet();

		//setting column heading
		$this->headerInitialize($sheet);
		$this->dataInitialize($sheet, $tehnical);

		// Redirect output to a client’s web browser (Excel5)
		$filename="anlagendoku-".mt_rand(1,100000).'.csv'; //just some random filename

		header('Content-Encoding: UTF-8');
		header("Content-Type: text/plain; charset=utf-8");
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Cache-Control: max-age=0');

		// If you're serving to IE over SSL, then the following may be needed
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
		header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'CSV');
		$objWriter->save('php://output');
		exit;
	}



	protected function headerInitialize($sheet)
	{

		$sheet->SetCellValue('A1', 'Gerate Nummer');
		$sheet->SetCellValue('B1', 'Fabriks Nr.');
		$sheet->SetCellValue('C1', 'Type');
		$sheet->SetCellValue('D1', 'Baujahr');
		$sheet->SetCellValue('E1', 'Hersteller');
		$sheet->SetCellValue('F1', 'Nennlast in kg');
		$sheet->SetCellValue('G1', 'Nenngeschwindigkeit in m/s');
		$sheet->SetCellValue('H1', 'Personen');
		$sheet->SetCellValue('I1', 'Antriebsart');
		$sheet->SetCellValue('J1', 'Schachtart');
		$sheet->SetCellValue('K1', 'Ladestellen');
		$sheet->SetCellValue('L1', 'Haltestellen');
		$sheet->SetCellValue('M1', 'Hubhohe in m');
		$sheet->SetCellValue('N1', 'Gesetz');
		$sheet->SetCellValue('O1', 'Prufintervall in Monaten');
		$sheet->SetCellValue('P1', 'Betriebskontrollenintervall');
		$sheet->SetCellValue('Q1', 'Aufzugswärter');
		$sheet->SetCellValue('R1', 'Wartungsfimra');
		$sheet->SetCellValue('S1', 'Letzte wiederkehrende Prufung');
		$sheet->SetCellValue('T1', 'Mangel');
		$sheet->SetCellValue('U1', 'Prufbericht PDF');
	}

	protected function dataInitialize($sheet, $tehnical)
	{

		foreach ($tehnical as $key => $tehnic) {

			$row = 1 + $key + 1;
			$user = $tehnic->getUser()->one();
			$prufungen = $tehnic->getTehnicReviews()->orderBy('id DESC')->one();

			$sheet->SetCellValue( 'A'.$row, $this->correct_print_string($tehnic->GerateNummer) );
			$sheet->SetCellValue( 'B'.$row, $this->correct_print_string($tehnic->FabriksNr) ); 
			$sheet->SetCellValue( 'C'.$row, $this->correct_print_string($tehnic->Type) );
			$sheet->SetCellValue( 'D'.$row, $this->correct_print_string($tehnic->Baujahr) );
			$sheet->SetCellValue( 'E'.$row, $this->correct_print_string($tehnic->Hersteller) );
			$sheet->SetCellValue( 'F'.$row, $this->correct_print_string($tehnic->Nennlast) );
			$sheet->SetCellValue( 'G'.$row, $this->correct_print_number($tehnic->Nenngeschwindigkeit) );
			$sheet->SetCellValue( 'H'.$row, $this->correct_print_number($tehnic->Personen)  );
			$sheet->SetCellValue( 'I'.$row, $this->correct_print_string($tehnic->Antriebsart)  );
			$sheet->SetCellValue( 'J'.$row, $this->correct_print_string($tehnic->Schachtart)  );
			$sheet->SetCellValue( 'K'.$row, $this->correct_print_number($tehnic->Ladestellen)  );
			$sheet->SetCellValue( 'L'.$row, $this->correct_print_number($tehnic->Haltestellen)  );
			$sheet->SetCellValue( 'M'.$row, $this->correct_print_number($tehnic->Hubhohe) );
			$sheet->SetCellValue( 'N'.$row, $this->correct_print_string($tehnic->Gesetzt) );
			$sheet->SetCellValue( 'O'.$row, $this->correct_print_number($tehnic->Profintervall) );
			$sheet->SetCellValue( 'P'.$row, $this->correct_print_string($tehnic->Betriebskontrollen) );
			$sheet->SetCellValue( 'Q'.$row, $this->renderAufzugswarter($tehnic)  );
			$sheet->SetCellValue( 'R'.$row, $this->renderFirmaName( $tehnic->fabric_id ));
			$sheet->SetCellValue( 'S'.$row, $this->correct_print_string($tehnic->LetzteDate) );
			$sheet->SetCellValue( 'T'.$row, $tehnic->last_prufungen_mang() );
			$sheet->SetCellValue( 'U'.$row, $tehnic->last_generate_PDF() );
		}
	}

	protected function correct_print_string($value)
	{
		if ( $value != null && $value != "" ) {

			return (string)$value;
		}else {
			return "null";
		}		
	}

	protected function correct_print_number($value)
	{
		if ( $value != null && $value != "" ) {

			return (string)$value;
		}else {
			return 0;
		}		
	}

	protected function renderAufzugswarter($model)
	{
		$name = [];
		if ( count($model->getAufzugswarters()->all()) > 0 ) {

			foreach ($model->getAufzugswarters()->all() as $key => $data) {
				array_push($name, $data->name);
				$name_separated_with_comma = implode(", ", $name);
			}

			return $name_separated_with_comma;
		}else {
			return null;
		}
	}

	protected function renderFirmaName($firma_id)
	{
		$firma = Wartungsfirma::findOne($firma_id);
		if ($firma) {

			return $firma->name;
		}else {
			return "null";
		}
	}
}