<?php

namespace backend\controllers;

use Yii;
use common\models\User;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\models\Role;
use common\models\Responsive;
/**
 * AdminController implements the CRUD actions for User model.
 */
class BaseController extends Controller
{
    public function beforeAction($action)
    {
        
        if ($this->logUser() == false &&  substr( Yii::$app->request->url, -strlen( 'site/login' ) ) != 'site/login') {
            header("Location: http://aufzugsbuch.at/admin/site/login");
            die();
        }
         
/*
        if ($this->logUser() == false &&  substr( Yii::$app->request->url, -strlen( 'site/login' ) ) != 'site/login') {
            header("Location: http://localhost:88/Aufzugstechnik/backend/web/site/login");
            die();
        }*/
        return true;
    }
   
    protected function currentUser()
    {
        $id = Yii::$app->user->getId();
        if($id)
        {
            $user= User::find()->where(['id' => $id])->one();
            return $user;
        }else {
            $this->redirect(['site/login']);
        }
    }

    protected function logUser()
    {
        $id = Yii::$app->user->getId();
        return $id ? User::find()->where(['id' => $id])->one() : false;
    }

    protected function isAdmin()
    {
        $id = Yii::$app->user->getId();
        return $id ? true : false;
    }

    public function isDesktop()
    {

        $responsive = $this->currentUser()->getResponsive();

        if(!$responsive) {
            $responsive = new Responsive();
            $responsive->name = "Responsive Application";
            $responsive->user_id = $this->currentUser()->id;
            $responsive->desktop = 1;
            $responsive->save();
        }

        if ( $responsive->desktop ) {

            return true;
        }else {

            return false;
        }
    }

    public function today()
    {

        return date("d.m.Y");
    }
}