<?php

namespace backend\controllers;

use Yii;
use yii\web\UploadedFile;
use common\models\User;
use common\models\Type;
use common\models\Responsive;
use common\models\CoworkerControll;
use common\models\search\AdminCoworkerSearch;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\SendInvitationForm;
use common\models\Role;
use yii\data\Pagination;
use common\models\search\AdmonCoworkerSearchGlobal;
use yii\helpers\ArrayHelper;
use yii\imagine\Image;
use Imagine\Gd;
use Imagine\Image\Box;
use Imagine\Image\BoxInterface;


class AdminCoworkerController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        if ($this->currentUser() && $this->currentUser()->role_id != "1")
        {
            $this->redirect(['site/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all User models.
     * @return mixed
     */
    public function actionIndex()
    {

        $searchModel = new AdminCoworkerSearch();
        $searchModelGlobal = new AdmonCoworkerSearchGlobal();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $users = $searchModelGlobal->search(Yii::$app->request->queryParams);

        $user_invitation = new SendInvitationForm();
        $desktop = $this->isDesktop();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'searchModel' => $searchModel,
            'user_invitation' => $user_invitation,
            'searchModelGlobal' => $searchModelGlobal,
            'users' => $users,
            'desktop' =>$desktop,
        ]);
    }

    public function actionShow($id)
    {
        $user = $this->findModel($id);
        $coworker_controll = $user->getCoworekerPermission();

        if ( $coworker_controll ) {

            $role = Role::find()->where(['name' => "Client"])->one();
            $betraibers = $this->betraiberNames( $coworker_controll );
            $types = $this->TypesNames( $coworker_controll );

            return $this->render('show', [
                'model' => $coworker_controll,
                'user' => $user,
                'role' => $role,
                'betraibers' => $betraibers,
                'types' => $types,
            ]);
        }else {

            return $this->redirect(['role', 'id' => $user->id]);
        }        
    }

    /**
     * Displays a single User model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new User model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new SendInvitationForm();
        $desktop = $this->isDesktop();
        if($model->load(Yii::$app->request->post()))
        {

            $user_password = bin2hex(openssl_random_pseudo_bytes(10));
            $user = $model->SendCoworkerInvitation($user_password);

            if (isset($user)) {  

                $responsive = new Responsive();
                $responsive->name = "Responsive Application";
                $responsive->desktop = 1;
                $responsive->mobile = 0;
                $responsive->user_id = $user->id;
                $responsive->save();

                Yii::$app->session->setFlash('success', 'You have successfully created coworker !');
                if ($model->send_mail == "1") {
                    $user_invitation = null;
                }
                return $this->redirect('index');
            }
        }
        return $this->render('create', [
            'model' => $model,
            'desktop' => $desktop,
        ]);    
    }

    /**
     * Updates an existing User model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $desktop = $this->isDesktop();
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) ) {

            $model->send_mail = "0";
            $model->username = $model->email;
            $this->uploadStamp( $model );

            if ( $model->save()) {

                Yii::$app->session->setFlash('success', 'You have successfully updated user !');
                return $this->redirect(['index']);
            }
        } else {
            return $this->render('update', [
                'model' => $model,
                'desktop' => $desktop,
            ]);
        }
    }

    public function actionChangePassword($id)
    {
        $desktop = $this->isDesktop();
        $model = $this->findModel($id);
        $model->setScenario('changePswAdmin');

        if ($model->load(Yii::$app->request->post()) ) {

            $model->setPassword($model->new_password);
            $model->client_password = $model->new_password;

            if ( $model->save() ) {

                Yii::$app->session->setFlash('success', 'You have successfully changed User password !');
                return $this->redirect(['index']);
            }         
        }else {

            return $this->render('password', [
                'model' => $model,
                'desktop' => $desktop,
            ]);
        }
    }

    public function actionRole($id)
    {

        $user = $this->findModel($id);
        $model = new CoworkerControll();
        $model->user_id = $user->id;
        $role = Role::find()->where(['name' => "Client"])->one();
        $clients = $role->getUsers()->all();
        $types = Type::find()->all(); 

        if ($model->load(Yii::$app->request->post()) ) {

            $this->ensureBetraibers($model->kunden_betraiber_array, $clients, $model);
            $this->ensureTypes($model->tehnical_type_array, $types, $model);

            if ( $model->save() ) {

                Yii::$app->session->setFlash('success', 'You have successfully add role to coworker !');
                return $this->redirect(['show', 'id' => $user->id]);
            }            
        }
        return $this->render('role', [
            'model' => $model,
            'user' => $user,
            'role' => $role,
        ]);      
    }

    public function actionUpdatePermission($user_id, $permission_id)
    {

        $user = $this->findModel($user_id);
        $model = CoworkerControll::findOne($permission_id);
        $model->user_id = $user->id;
        $role = Role::find()->where(['name' => "Client"])->one();
        $clients = $role->getUsers()->all();
        $types = Type::find()->all(); 

        if ($model->load(Yii::$app->request->post()) ) {

            $this->ensureBetraibers($model->kunden_betraiber_array, $clients, $model);
            $this->ensureTypes($model->tehnical_type_array, $types, $model);

            if ( $model->save() ) {

                Yii::$app->session->setFlash('success', 'You have successfully UPDATE role to coworker !');
                return $this->redirect(['show', 'id' => $user->id]);
            }            
        }

        return $this->render('update_permission', [
            'model' => $model,
            'user' => $user,
            'role' => $role,
        ]);
    }

    protected function ensureBetraibers($kunden_betraiber_array, $clients, $model)
    {
        if ( $kunden_betraiber_array == "" ) {

            $array_role = [ 2 ];
            $clients = User::find()->where([ 'role_id' => $array_role ])->all();

            $user_ids = ArrayHelper::map($clients, 'id', 'id');
            $kunden_betraibers = serialize($user_ids); 
            $model->kunden_betraiber_string_array = $kunden_betraibers;
        }else {

            $kunden_betraiber_array = serialize($kunden_betraiber_array);
            $model->kunden_betraiber_string_array = $kunden_betraiber_array;
        }
    }

    protected function ensureTypes($type_array, $types, $model)
    {
        if ( $type_array == "" ) {

            $type_names = ArrayHelper::map($types, 'id', 'id');
            #$type_ids = print_r($type_ids, true);
            $type_names = serialize($type_names);
            $model->tehnical_type_string_array = $type_names;
        }else {

            #$type_ids = print_r($type_array, true);
            $type_names = serialize($type_array);
            $model->tehnical_type_string_array = $type_names;
        }
    }

    protected function betraiberNames( $coworker_controll )
    {

        $kunden_betraibers = $coworker_controll->kunden_betraiber_string_array;
        $kunden_betraibers = unserialize($kunden_betraibers);
        $string = '';
        
        foreach ($kunden_betraibers as $key => $user_id) {

            if ( $user_id != null && $user_id != "" ) {

                $company = User::find()->where([ 'id' => (int)$user_id ])->one();

                if ( isset($company) ) {

                    $users = User::find()->where([ 'Betreiber' => $company->Betreiber ])->all();

                    $ids = ArrayHelper::map($users,'id','Betreiber');
                    $value = implode(", ",$ids);
                    $string .= $value.", ";
                }
            }
        }

        $ids =  explode(', ', $string);
        $ids = array_unique($ids);
        return $ids;
    }

    protected function TypesNames( $coworker_controll )
    {
        $type_ids = $coworker_controll->tehnical_type_string_array;
        $type_ids = unserialize($type_ids);

        $types = Type::find()->where(['id' => $type_ids])->all();

        return ArrayHelper::map($types,'id','name');
    }

    /**
     * Deletes an existing User model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        if ($this->findModel($id)->delete()) {
            Yii::$app->session->setFlash('success', 'You have successfully deleted user !');
        }

        return $this->redirect(['index']);
    }

    public function actionSendEmail()
    {
        $user_id = $_GET['user_id'];
        $user_invitation = new SendInvitationForm();
        $this->initialize_user_for_send_email($user_id, $user_invitation);

        $query = User::find();
        $count = $query->count();
        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $count
        ]);

        $dataProvider = $query->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        return $this->render('send_email', [
            'dataProvider' => $dataProvider,
            'pagination' => $pagination,
            'user_invitation' => $user_invitation,
        ]);

    }

    /**
     * Finds the User model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return User the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */

    protected function initialize_user_for_send_email($user_id, $user_invitation)
    {   
        if ($user_id) {

            $user = $this->findModel($user_id);

            if ($user_invitation->load(Yii::$app->request->post()) ) {

                $this->send_message_from_form($user, $user_invitation);
            }
        }        
    }

    protected function send_message_from_form($user, $user_invitation)
    {   

        if ( $user_invitation->send_standard_content_with_email ) {

            $this->sendMailToUser($user, $user->client_password, $user_invitation);
        }else {

            $this->sendMailToUserWithoutStandardContent($user, $user_invitation);
        }
        return $this->redirect('index');   
    }

    protected function findModel($id)
    {
        if (($model = User::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    protected function sendMailToUser($user, $user_password, $user_invitation)
    {

        Yii::$app->mailer->compose('contact', ['model' => $user, 'password' => $user_password, 'user_invitation' => $user_invitation])
            ->setFrom('office@anlagendoku.com')
            ->setTo($user->email)
          #  ->setCc(array('belmir.hamidovic@anlagendoku.com'))
            ->setSubject("Ihre Zugangsdaten zu anlagendoku.com")
            ->send();
        Yii::$app->session->setFlash('success', 'The mail has been sent successfully !');  
    }


    protected function sendMailToUserWithoutStandardContent($user, $user_invitation)
    {
        if ( $user_invitation->emails ) {
            $emails = explode(", ", $user_invitation->emails);
            Yii::$app->mailer->compose('contact_without_standard_content', ['user_invitation' => $user_invitation])
                ->setFrom('office@anlagendoku.com')
                ->setTo($emails)
                ->setCc(array('belmir.hamidovic@anlagendoku.com'))
                ->setSubject($user_invitation->subject)
                ->send();
            Yii::$app->session->setFlash('success', 'The mails have been successfully sent !');
        }else {

            Yii::$app->mailer->compose('contact_without_standard_content', ['model' => $user, 'user_invitation' => $user_invitation])
                ->setFrom('office@anlagendoku.com')
                ->setTo($user->email)
                ->setCc(array('belmir.hamidovic@anlagendoku.com'))
                ->setSubject($user_invitation->subject)
                ->send();
            Yii::$app->session->setFlash('success', 'The mail has been sent successfully !');
        }   
    }

    protected function updatePasswordForUser($user, $user_password)
    {
        Yii::$app->mailer->compose('update_contact', ['model' => $user, 'password' => $user_password])
            ->setFrom('office@anlagendoku.com')
            ->setTo($user->email)
          #  ->setCc(array('belmir.hamidovic@anlagendoku.com'))
            ->setSubject("Anlagendoku Update Password")
            ->send();
    }

    public function display_pagination_unlesss_SearchQueryParams()
    {       
        if ( !isset($_GET['page']) && Yii::$app->request->queryParams && $_GET['AdmonCoworkerSearchGlobal']["globalSearch"] != "" ) {
            return false;
        }else {
            return true;
        }
    }

    protected function uploadStamp( $model )
    {   
        $stamp = UploadedFile::getInstance($model, 'stamp');
        $s3_env = S3_ENV;
        $old_stamp = $model->OldAttributes['stamp'];
        $random_string = bin2hex(openssl_random_pseudo_bytes(5));
        $stampformat = $stamp ? $stamp->baseName. bin2hex(openssl_random_pseudo_bytes(5)).'.'.$stamp->extension : $old_stamp;
        $model->stamp = $stampformat;

        if ( $stamp ) {
            $stamp->saveAs('uploads/'.$model->stamp);

            $path = 'uploads/thumbnail/';
            $size_1 = 646;
            $size_2 = 210;

            $this->reduceImage($stampformat, $path, $size_1, $size_2);

            Yii::$app->get('s3bucket')->upload($s3_env. 'profile/'.$model->stamp, 'uploads/thumbnail/'.$model->stamp);
            gc_collect_cycles();
            unlink('uploads/'.$model->stamp);
            unlink('uploads/thumbnail/'.$model->stamp); 
            $this->deleteFromS3($old_stamp, $s3_env);
        }
    }

    protected function reduceImage($imageformat, $path, $size_1, $size_2)
    {

        $imagine = Image::getImagine();

        $image_thumb = $imagine->open('uploads/' . $imageformat);
        $image_thumb->resize(new Box( $size_1, $size_2 ))->save($path . $imageformat, ['quality' => 70]);
    }
    
    protected function deleteFromS3($image, $env)
    {
        $env = $env;
        if ($image) {
            Yii::$app->get('s3bucket')->delete($env. 'profile/'.$image);
        }
    }
}